#include "mbed.h"
#include "buzzer.h"

InterruptIn pjesakTipka(D6, PullUp);
DigitalOut aCrveno(A0);
DigitalOut aZuto(A1);
DigitalOut aZeleno(A2);
DigitalOut pCrveno(A4);
DigitalOut pZeleno(A5);
Beep buzzer(D2);  
Ticker ticker;

bool pjesakTipkalo = false;  
                                
void kliknutoTipkalo() {  
    pjesakTipkalo = true;
}

void sound() {
    if(pZeleno == 1) {
        buzzer.beep(400, 0.5);
    } else {
        buzzer.beep(200, 0.5);
    }
}

void glavniSemafor() {
    pCrveno = 1;
    aCrveno = 1;
    wait(5);
    aCrveno = 1;
    aZuto = 1;
    wait(2);
    aZuto = 0;
    aCrveno = 0;
    aZeleno = 1;
    wait(5);
    aZeleno = 0;
    aCrveno = 1;
}

void sporedniSemafor() {
    pCrveno = 1;
    wait(5);
    pCrveno = 0;
    pZeleno = 1;
    wait(5);
    pZeleno = 0;
    pCrveno = 1;
    pjesakTipkalo = false;
}
        
int main() {
    
    ticker.attach(&sound, 1.0);  
    pjesakTipka.fall(&kliknutoTipkalo);  
    
    while(true) {
        if(!pjesakTipkalo) {  
            glavniSemafor(); 
        } else {
            sporedniSemafor();
        }
    }
}