#include "mbed.h"
#include "Ograda.h"


Ograda motor(D2,D3,D4,D5);
InterruptIn sw_start(D6, PullDown);
InterruptIn sw_end(D7, PullDown);
InterruptIn sensor(D8, PullDown);
InterruptIn signal_rx(USER_BUTTON, PullUp);
int pomocna=0;
Serial pc(USBTX, USBRX);
Timer debounce;


void TerraTerm() // ispisivanje podataka u TerraTerm pomoću serijske komunikacije
{
    pc.printf("Ograda zatvorena =1, nije zatvorena=0: %d \n \r ", sw_start.read());
    pc.printf("Ograda otvorena =1,  djelomicno otvorena=0: %d \n  \n\r ", sw_end.read());
    pc.printf("Senzor = %d \n  \n\r ", sensor.read());
}


void zaustavi() //funkcija za zaustavljanje motora
{
    debounce.start();
    if (debounce.read_ms()>200) 
    {
        motor.zaustavi();
        pc.printf("Zaustavaljanje motora i gasenje signalizacije \n \r ");
        pomocna=1;         //služi za povratak u glavnu funkciju
        TerraTerm();        //ispis ulaza 
        debounce.reset();
    }

}


void otvori()  // procedura otvaranja ograde - senzor pri otvaranju smeta
{
    sensor.rise(NULL); // sprijecavanje rada senzora tijekom otvaranja ograde
    sensor.fall(NULL);//
    motor.pokreni(2, 0.0);
    pc.printf("Otvaranje ograde \n  \n \r ");
    TerraTerm();
}



void pocetna() // funkcija koja se izvodi samo prvi puta - npr. ograda ostala djelomično otvorena
{
    if(sw_start.read()==0&&sw_end.read()==0) 
    {
        pc.printf("Zatvaranje ograde za 8s \n \n \r ");
        sensor.rise(&zaustavi);

        wait(8);
        motor.pokreni(1, 2.0);
        pc.printf("Zatvaranje ograde \n \n \r ");
        TerraTerm();
    }
}



void glavna() // funkcija provjere stanja ulaza koja se izvodi kod svakog novog događaja
{
    
    pomocna=0;
    signal_rx.rise(NULL); //blokiranje signala iz daljinskog uptavljača ukoliko ograda nije zatvorena

    if(sw_start.read()==0&&sw_end.read()==1) 
    {
        sensor.rise(&zaustavi);
        sensor.fall(&pocetna);
        pc.printf("Zatvaranje ograde za 8s \n \n \r ");
        wait(8);
        motor.pokreni(1, 2.0);
        pc.printf("Zatvaranje ograde \n \n \r ");
        TerraTerm();
    }


    if(sw_start.read()==1) 
    {
        signal_rx.rise(&otvori);
        sensor.fall(NULL);
        pc.printf("Ceka se signal za otvaranje  \n\n \r ");
        TerraTerm();
    }
}


int main()
{
    TerraTerm();
    signal_rx.rise(NULL); // signal za otvaranje ograde nije potreban ukoliko ograda nije zatvorena
    sw_start.rise(&zaustavi);
    sw_end.rise(&zaustavi); //definiranje događaja prilikom rastućih bridova
    sensor.rise(&zaustavi);

    pocetna();
    glavna();

    while(1) {
      
        if(sw_start.read()==1&&sw_end.read()==1) // provjera jesu li prekidači u kratkom spoju
        
        { 
            pc.printf("NEISPRAVNI KRAJNJI PREKIDACI  \n\n \r ");
            zaustavi();
            break;
        }


        if(pomocna==1) 
        {
            glavna();
        }
    }
}
