#include "mbed.h"
#include "SegDisplay.h"
InterruptIn button1(PA_5); //Interrupt pin
InterruptIn button2(PA_6); //Interrupt pin
Serial pc(USBTX, USBRX); //Serijska komunikacija s računalom
DigitalOut greenLED(PA_10);
DigitalOut yellowLED(PB_3);
DigitalOut redLED(PB_5);
PwmOut buzzer(PA_4);
Ticker blink; //Ticker za blinkanje ledice
Timer debounce; //Timer za micanje debouncinga
void toggle(void); //inicijalizacija funkcije
void toggle2(void); //inicijalizacija funkcije
int state=3;  // inicijalizacija varijable
int razina=0;

void redBlink()
{
    redLED=!redLED;

}

void yellowBlink()
{
    yellowLED=!yellowLED;

}

void greenBlink()
{
    greenLED=!greenLED;

}

void signalizacija(int razina)  // Funckija za signalizaciju razine popunjenosti spremnika
{
    if (razina <= 30) {
        blink.attach(&greenBlink, 0.25); // Ticker za blinkanje zelene LED-ice
        yellowLED = 0;
        redLED= 0;
        Seg1 = SegConvert(razina%10); // Pozivanje funkcije za ispis na 7 seg. displayu
        buzzer=0; // set duty cycle
    } else if (razina >30 && razina <= 60) {
        blink.detach();
        greenLED= 1;
        blink.attach(&yellowBlink, 0.25); // Ticker za blinkanje žute LED-ice
        redLED = 0;
        Seg1 = SegConvert(razina%10); // Pozivanje funkcije za ispis na 7 seg. displayu
        buzzer=0; // set duty cycle
    } else if (razina >60 && razina <= 90) {
        blink.detach();
        greenLED= 1;
        yellowLED = 1;
        blink.attach(&redBlink, 0.25); // Ticker za blinkanje crvene LED-ice
        Seg1 = SegConvert(razina%10); // Pozivanje funkcije za ispis na 7 seg. displayu
        buzzer=0; // set duty cycle
    } else if (razina >90 && razina <= 100) {
        blink.detach();
        redLED = 1;
        yellowLED = 1;
        greenLED= 1;
        Seg1 = SegConvert(razina%10); // Pozivanje funkcije za ispis na 7 seg. displayu
        buzzer=0.125; // set duty cycle
    }
}


int main()
{
    debounce.start();
    SegInit(); // Pozivanje funkcije za inicijalizaciju 7 seg. displaya
    while (true) {
        button1.rise(&toggle); // Interrupt, punjenje spremnika
        button2.rise(&toggle2); // Interrupt, pražnjenje spremnika
        if(state==1) { // Punjenje spremnika vodom
            pc.printf("Postotak popunjenosti spremnika: %d\n\r", razina);
            razina++;
            wait(0.25);
            signalizacija(razina);
            if (razina == 100) {
                state=3;
            }
        } else if(state==2) { // Pražnjenje spremnika
            pc.printf("Postotak popunjenosti spremnika: %d\n\r", razina);
            razina--;
            wait(0.25);
            signalizacija(razina);
            if (razina == 0) {
                state=3;
            }
        } else if(state==3) { // Spremnik je ili pun ili prazan
            if (razina == 100) {
                pc.printf("Spremnik je pun: %d\n\r", razina);;
            } else if (razina == 0) {
                pc.printf("Spremnik je prazan: %d\n\r", razina);;
            }
            signalizacija(razina);
        }
    }

}

//Interrupt, punjenje spremnika
void toggle()
{
    if (debounce.read_ms()>200) { // only allow toggle if debounce timer
        state=1; // has passed 200 ms
    }
    debounce.reset(); // restart timer when the toggle is performed
}

//Interrupt, pražnjenje spremnika
void toggle2()
{
    if (debounce.read_ms()>200) { // only allow toggle if debounce timer
        state=2; // has passed 200 ms

    }
    debounce.reset(); // restart timer when the toggle is performed
}