#include "mbed.h"
#include "SegDisplay.h"
InterruptIn button1(PA_5); //Interrupt pin
InterruptIn button2(PA_6); //Interrupt pin
Serial pc(USBTX, USBRX); //Serijska komunikacija s računalom
DigitalOut redLED(PA_10);
DigitalOut yellowLED(PB_3);
DigitalOut greenLED(PB_5);
Ticker blink; //Ticker za blinkanje ledice
Timer debounce; //Timer za micanje debouncinga
void toggle(void); //inicijalizacija funkcije
void toggle2(void); //inicijalizacija funkcije
int state=1;  // inicijalizacija varijable
int sec=0; // inicijalizacija varijable

void yellowBlink()
{
    yellowLED=!yellowLED;

}

void odbrojavanje() // Funkcija za odbrojavanje trajanja signalizacije na semaforu
{
    while (sec>0 && state!=5) {
        Seg1 = SegConvert(sec); // Pozivanje funkcije za ispis na 7 seg. displayu
        wait_us (1000000);
        sec--;
    }
}

void signalizacija(int red, int yellow, int green, int trajanje)  // Funckija za signalizaciju na semaforu
{
    redLED = red;
    yellowLED = yellow;
    greenLED= green;
    sec = trajanje;
}

int main()
{
    debounce.start();
    SegInit(); // Pozivanje funkcije za inicijalizaciju 7 seg. displaya
    while (true) {
        button1.rise(&toggle); // Interrupt, semafor trenutno nije u funkciji
        button2.rise(&toggle2); // Interrupt, vracanje semafora u funkcionalno stanje
        if(state==1) { // Crveno na semaforu
            pc.printf("Zaustavi se.\n");
            blink.detach();
            signalizacija(1,0,0,9);
            state=2;
        } else if(state==2) { // Prijelaz iz crvenog u zeleno
            pc.printf("Pripremi se za kretanje.\n");
            signalizacija(1,1,0,3);
            state=3;
        } else if(state==3) { // Zeleno na semaforu
            pc.printf("Kreni.\n");
            signalizacija(0,0,1,9);
            state=4;
        } else if(state==4) { // Prijelaz iz zelenog u crveno
            pc.printf("Kreni se zaustavljati.\n");
            signalizacija(0,1,0,3);
            state=1;
        } else  if(state==5) { // Semafor izvan funckije
            pc.printf("Semafor izvan funkcije ili prometna nesreća.\n");
            signalizacija(0,0,0,0);
            blink.attach(&yellowBlink, 0.25); // Ticker za blinkanje LED
            state=6;
            Seg1 = SegConvert(10);
        }
        odbrojavanje();
    }

}

//Interrupt, semafor trenutno nije u funkciji
void toggle()
{
    if (debounce.read_ms()>200) { // only allow toggle if debounce timer
        state=5; // has passed 200 ms
    }
    debounce.reset(); // restart timer when the toggle is performed
}

//Interrupt, vracanje semafora u funkcionalno stanje
void toggle2()
{
    if (debounce.read_ms()>200) { // only allow toggle if debounce timer
        state=1; // has passed 200 ms

    }
    debounce.reset(); // restart timer when the toggle is performed
}