#include "mbed.h"
#include "TrafficFlash.h"
#include "TrafficLight1.h"
#include "TrafficLight2.h"

//Ticker, Loop detectors
Ticker LDT1;
Ticker LDT2;

//Users functions
void TL1_DSP(void);
void TL2_DSP(void);
void DSP1_Time();
void DSP2_Time();
void TL1_button(void);
void TL2_button(void);
void LoopDT1(void);
void LoopDT2(void);
void Task_1(void);
void Task_2(void);
void Task_3(void);
void Task_4(void);
void Task_5(void);
void Task_6(void);
void Task_7(void);

//Global variable
char i=0,j=0;

//Timers
Timer timer1;
Timer timer2;
Timer debounce;

//Digital inputs
DigitalIn sw1(PE_4);
DigitalIn sw2(PC_13);

//7-segment display, TLD1 digital outputs
DigitalOut TLD1_A(PE_10);
DigitalOut TLD1_B(PE_11);
DigitalOut TLD1_C(PE_12);
DigitalOut TLD1_D(PE_13);
DigitalOut TLD1_E(PE_14);
DigitalOut TLD1_F(PE_15);
DigitalOut TLD1_G(PB_10);

//7-segment display, TLD2 digital outputs
DigitalOut TLD2_A(PB_0);
DigitalOut TLD2_B(PB_8);
DigitalOut TLD2_C(PB_9);
DigitalOut TLD2_D(PE_1);
DigitalOut TLD2_E(PE_7);
DigitalOut TLD2_F(PE_8);
DigitalOut TLD2_G(PE_9);

//Traffic ligt 1, digital outputs
TrafficLight1 TL1_R(PC_0);
TrafficLight1 TL1_Y(PC_1);
TrafficLight1 TL1_G(PC_2);

//Traffic light 2, digital inputs
TrafficLight2 TL2_R(PA_0);
TrafficLight2 TL2_Y(PA_1);
TrafficLight2 TL2_G(PA_2);

//Traffic light button, interrupt
InterruptIn button(PE_5);

int main()
{
    sw1.mode(PullUp);
    sw2.mode(PullUp);
    Task_1();

    while(true) {
        //Dogadaji
        Task_2();
        Task_3();
        Task_4();
        Task_5();
        Task_6();
        Task_7();
    }
}

//Users functions
void TL1_DSP(char i)
{

    switch (9-i) {
        case 0:
            TLD1_A = 1;
            TLD1_B = 1;
            TLD1_C = 1;
            TLD1_D = 1;
            TLD1_E = 1;
            TLD1_F = 1;
            TLD1_G = 0;
            break;
        case 1:
            TLD1_A = 0;
            TLD1_B = 1;
            TLD1_C = 1;
            TLD1_D = 0;
            TLD1_E = 0;
            TLD1_F = 0;
            TLD1_G = 0;
            break;
        case 2:
            TLD1_A = 1;
            TLD1_B = 1;
            TLD1_C = 0;
            TLD1_D = 1;
            TLD1_E = 1;
            TLD1_F = 0;
            TLD1_G = 1;
            break;
        case 3:
            TLD1_A = 1;
            TLD1_B = 1;
            TLD1_C = 1;
            TLD1_D = 1;
            TLD1_E = 0;
            TLD1_F = 0;
            TLD1_G = 1;
            break;
        case 4:
            TLD1_A = 0;
            TLD1_B = 1;
            TLD1_C = 1;
            TLD1_D = 0;
            TLD1_E = 0;
            TLD1_F = 1;
            TLD1_G = 1;
            break;
        case 5:
            TLD1_A = 1;
            TLD1_B = 0;
            TLD1_C = 1;
            TLD1_D = 1;
            TLD1_E = 0;
            TLD1_F = 1;
            TLD1_G = 1;
            break;
        case 6:
            TLD1_A = 1;
            TLD1_B = 0;
            TLD1_C = 1;
            TLD1_D = 1;
            TLD1_E = 1;
            TLD1_F = 1;
            TLD1_G = 1;
            break;
        case 7:
            TLD1_A = 1;
            TLD1_B = 1;
            TLD1_C = 1;
            TLD1_D = 0;
            TLD1_E = 0;
            TLD1_F = 0;
            TLD1_G = 0;
            break;
        case 8:
            TLD1_A = 1;
            TLD1_B = 1;
            TLD1_C = 1;
            TLD1_D = 1;
            TLD1_E = 1;
            TLD1_F = 1;
            TLD1_G = 1;
            break;
        case 9:
            TLD1_A = 1;
            TLD1_B = 1;
            TLD1_C = 1;
            TLD1_D = 1;
            TLD1_E = 0;
            TLD1_F = 1;
            TLD1_G = 1;
            break;
    }
}
void TL2_DSP(char j)
{

    switch(9-j) {
        case 0:
            TLD2_A = 1;
            TLD2_B = 1;
            TLD2_C = 1;
            TLD2_D = 1;
            TLD2_E = 1;
            TLD2_F = 1;
            TLD2_G = 0;
            break;
        case 1:
            TLD2_A = 0;
            TLD2_B = 1;
            TLD2_C = 1;
            TLD2_D = 0;
            TLD2_E = 0;
            TLD2_F = 0;
            TLD2_G = 0;
            break;
        case 2:
            TLD2_A = 1;
            TLD2_B = 1;
            TLD2_C = 0;
            TLD2_D = 1;
            TLD2_E = 1;
            TLD2_F = 0;
            TLD2_G = 1;
            break;
        case 3:
            TLD2_A = 1;
            TLD2_B = 1;
            TLD2_C = 1;
            TLD2_D = 1;
            TLD2_E = 0;
            TLD2_F = 0;
            TLD2_G = 1;
            break;
        case 4:
            TLD2_A = 0;
            TLD2_B = 1;
            TLD2_C = 1;
            TLD2_D = 0;
            TLD2_E = 0;
            TLD2_F = 1;
            TLD2_G = 1;
            break;
        case 5:
            TLD2_A = 1;
            TLD2_B = 0;
            TLD2_C = 1;
            TLD2_D = 1;
            TLD2_E = 0;
            TLD2_F = 1;
            TLD2_G = 1;
            break;
        case 6:
            TLD2_A = 1;
            TLD2_B = 0;
            TLD2_C = 1;
            TLD2_D = 1;
            TLD2_E = 1;
            TLD2_F = 1;
            TLD2_G = 1;
            break;
        case 7:
            TLD2_A = 1;
            TLD2_B = 1;
            TLD2_C = 1;
            TLD2_D = 0;
            TLD2_E = 0;
            TLD2_F = 0;
            TLD2_G = 0;
            break;
        case 8:
            TLD2_A = 1;
            TLD2_B = 1;
            TLD2_C = 1;
            TLD2_D = 1;
            TLD2_E = 1;
            TLD2_F = 1;
            TLD2_G = 1;
            break;
        case 9:
            TLD2_A = 1;
            TLD2_B = 1;
            TLD2_C = 1;
            TLD2_D = 1;
            TLD2_E = 0;
            TLD2_F = 1;
            TLD2_G = 1;
            break;
    }
}
void DSP1_Time()
{
    while(i<10) {
        switch(i) {
            case 6:
                TL1_R.Off();
                TL1_Y.Off();
                TL1_G.Off();
                TL2_R.On();
                TL2_Y.Off();
                TL2_G.Off();
                break;
            case 7:
                TL1_R.Off();
                TL1_Y.Off();
                TL1_G.On();
                TL2_R.On();
                TL2_Y.Off();
                TL2_G.Off();
                break;
            case 8:
                TL1_R.Off();
                TL1_Y.Off();
                TL1_G.Off();
                TL2_R.On();
                TL2_Y.Off();
                TL2_G.Off();
                break;
            case 9:
                TL1_R.Off();
                TL1_Y.Off();
                TL1_G.On();
                TL2_R.On();
                TL2_Y.Off();
                TL2_G.Off();
                break;
            default:
                TL1_R.Off();
                TL1_Y.Off();
                TL1_G.On();
                TL2_R.On();
                TL2_Y.Off();
                TL2_G.Off();
        }
        if (timer1.read_ms()>=1000) {
            TL1_DSP(i);
            timer1.reset();
            i++;
        }
        debounce.start();
        button.rise(&TL1_button);
        LDT1.attach(&LoopDT1, 0.2);
    }
    i=0;
    timer1.stop();
}
void DSP2_Time()
{
    while(j<10) {
        switch(j) {
            case 6:
                TL1_R.On();
                TL1_Y.Off();
                TL1_G.Off();
                TL2_R.Off();
                TL2_Y.Off();
                TL2_G.Off();
                break;
            case 7:
                TL1_R.On();
                TL1_Y.Off();
                TL1_G.Off();
                TL2_R.Off();
                TL2_Y.Off();
                TL2_G.On();
                break;
            case 8:
                TL1_R.On();
                TL1_Y.Off();
                TL1_G.Off();
                TL2_R.Off();
                TL2_Y.Off();
                TL2_G.Off();
                break;
            case 9:
                TL1_R.On();
                TL1_Y.Off();
                TL1_G.Off();
                TL2_R.Off();
                TL2_Y.Off();
                TL2_G.On();
                break;
            default:
                TL1_R.On();
                TL1_Y.Off();
                TL1_G.Off();
                TL2_R.Off();
                TL2_Y.Off();
                TL2_G.On();
        }
        if (timer2.read_ms()>=1000) {
            TL2_DSP(j);
            timer2.reset();
            j++;
        }
        debounce.start();
        button.rise(&TL2_button);
        LDT2.attach(&LoopDT2, 0.2);
    }
    j=0;
    timer2.stop();
}
void TL1_button()
{
    if (debounce.read_ms()>200)
        i=10;
    debounce.reset();
}
void TL2_button()
{
    if (debounce.read_ms()>200)
        j=10;
    debounce.reset();
}
void LoopDT1()
{
    if (sw1==1 && sw2==0) {
        i=10;
    }
}
void LoopDT2()
{
    if (sw2==1 && sw1==0) {
        j=10;
    }
}
void Task_1()
{
    TL1_R.Off();
    TL1_Y.Off();
    TL1_G.Off();
    TL2_R.Off();
    TL2_Y.Off();
    TL2_G.Off();
    wait(1);
}
void Task_2()
{
    timer1.start();
    DSP1_Time();
    TLD1_A = 0;
    TLD1_B = 0;
    TLD1_C = 0;
    TLD1_D = 0;
    TLD1_E = 0;
    TLD1_F = 0;
    TLD1_G = 0;
}
void Task_3()
{
    TL1_R.Off();
    TL1_Y.On();
    TL1_G.Off();
    TL2_R.On();
    TL2_Y.Off();
    TL2_G.Off();
    wait(1.5);
}
void Task_4()
{
    TL1_R.On();
    TL1_Y.Off();
    TL1_G.Off();
    TL2_R.On();
    TL2_Y.On();
    TL2_G.Off();
    wait(1.5);
}
void Task_5()
{
    timer2.start();
    DSP2_Time();
    TLD2_A = 0;
    TLD2_B = 0;
    TLD2_C = 0;
    TLD2_D = 0;
    TLD2_E = 0;
    TLD2_F = 0;
    TLD2_G = 0;
}
void Task_6()
{
    TL1_R.On();
    TL1_Y.Off();
    TL1_G.Off();
    TL2_R.Off();
    TL2_Y.On();
    TL2_G.Off();
    wait(1.5);
}
void Task_7()
{
    TL1_R.On();
    TL1_Y.On();
    TL1_G.Off();
    TL2_R.On();
    TL2_Y.Off();
    TL2_G.Off();
    wait(1.5);
}
