#include "mbed.h"
#include "led.h"
//definiranje izlaza
LED led1(D11);
LED led2(D12);
LED led3(D13);
BusOut Seg1(D2,D3,D4,D5,D6,D7,D8,D9);
//definiranje timera
Timer debounce;
Ticker flipper;
Timer timer;

//definiranje interrupt buttona
InterruptIn button(USER_BUTTON);

//funkcija za 7segmentni display
char SegConvert(int SegValue) {
 char SegByte=0x00;
 switch (SegValue) {
 case 0 : SegByte = 0x3F;break; 
 case 1 : SegByte = 0x06;break;
 case 2 : SegByte = 0x5B;break;
 case 3 : SegByte = 0x4F;break; 
 case 4 : SegByte = 0x66;break;
 case 5 : SegByte = 0x6D;break;
 case 6 : SegByte = 0x7D;break;
 case 7 : SegByte = 0x07;break;
 case 8 : SegByte = 0x7F;break;
 case 9 : SegByte = 0x6F;break;
 case 10 : SegByte = 0x00;break;
 }
 return SegByte;
}
//funkcija tickera
void ticker(){
    led3.promjena();
}
//funkcija prekida
void prekid(){
    if(debounce.read_ms()>200){
        led1.stanje(0);
        led2.stanje(0);
        led3.stanje(0);
        Seg1=SegConvert(10);
        wait(5.0);
       if(timer.read()<=9){
               
               led1.stanje(1);
               led2.stanje(0);
               }
               else{
               led1.stanje(0);
               led2.stanje(1);
               }
           }
            debounce.reset();

}
//glavna funkcija
int main() {
led1.stanje(1);
led2.stanje(0);
led3.stanje(0);
debounce.start();
button.rise(&prekid);

flipper.attach(&ticker,0.5);
  while(1){
        timer.start();
        for(int i=9;i>=0;i--){
          Seg1=SegConvert(i); 

            wait(1.0);
                }  
        led1.promjena();
        led2.promjena();
           for(int j=5;j>=0;j--){
               Seg1=SegConvert(j);
               wait(1.0);
               }
        led2.promjena();
        led1.promjena();
        timer.stop();
        
        timer.reset();
        }
}



  