#include "Ograda.h"
#include "mbed.h"


Ograda::Ograda(PinName pin1, PinName pin2, PinName pin3, PinName pin4) : motor_open(pin1), motor_close(pin2), warn_light(pin3), brake(pin4) // Konstruktor, inicijalizacija varijabli
{
    motor_open=0;
    motor_close=0;
    warn_light=0;
    brake=1;

    wait_ms(50);
}


void Ograda::start(int dir, float time) //Funkcija za pokretanje motora u željenom smjeru s željenim čekanjem prije otvaranja
{
    
    signal_blink.attach(callback(this, &Ograda::signalizacija), 1.0 );
    
    
    if(time>0.0) // provjera ima li cekanja
    {
    wait(time);
    }
    
    if(dir==0) { //0 - zatvaranje ograde
        brake=0;
        motor_open=0;
        motor_close=1;
    }
    
    if(dir==1) { // 1 - otvaranje ograde
        brake=0;
        motor_open=1;
        motor_close=0;
    }
}


void Ograda::signalizacija()
{
    warn_light=!warn_light;
}


void Ograda::stop() // procedura za zaustavljanje motora
{
    motor_open=0;
    motor_close=0;
    brake=1;
    signal_blink.detach();
    warn_light=0;  
}