#include "objectPosition.h"
#include <math.h>


ObjectPosition::ObjectPosition()
{
}

ObjectPosition::ObjectPosition(float angle, float distance) : m_angle((angle)*PI/180), m_distance(distance)
{
    m_x = cos(m_angle) * m_distance;
    m_y = sin(m_angle) * m_distance;
}

ObjectPosition::ObjectPosition(int x, int y) : m_x(x), m_y(y)
{
    m_distance = sqrt((m_x * m_x)+(m_y * m_y));
    m_angle = atan(m_y / m_x);
}

ObjectPosition::~ObjectPosition()
{
}

void ObjectPosition::setDistance(float distance)
{
    m_distance = distance;
    m_x = cos(m_angle) * m_distance;
    m_y = sin(m_angle) * m_distance;
}

void ObjectPosition::setAngle(float angle)
{
    m_angle = (angle)*PI/180;
    m_x = cos(m_angle) * m_distance;
    m_y = sin(m_angle) * m_distance;
}

float ObjectPosition::getAngle()
{
    return m_angle*180/PI;
}

float ObjectPosition::getDistance()
{
    return m_distance;
}

double ObjectPosition::getXCoordinate()
{
    return m_x;
}

double ObjectPosition::getYCoordinate()
{
    return m_y;
}

double ObjectPosition::getDistanceFromOtherObj(ObjectPosition* otherObjPos)
{
    return sqrt(pow(otherObjPos->getXCoordinate() - this->m_x, 2) + pow(otherObjPos->getYCoordinate() - this->m_y, 2));
}
