#include "mbed.h"
#include "ledSignalizacija.h"

Serial pc(USBTX, USBRX);
AnalogIn temperaturniSenzor(A0);
PwmOut buzzer(D5);
Timer timer;
Ticker zvucniSignal;
InterruptIn button(D7, PullDown);
Timer debounce;
LedSignalizacija ledSig(D4, D3, D2);

void provjeraSenzora();
void upozorenje();

int main()
{
   debounce.start();
   button.rise(&upozorenje);    
   zvucniSignal.attach(&provjeraSenzora, 0.5);
   buzzer.period_ms(20);
   
   while(1){
           pc.printf("Temperatura: %f\r", temperaturniSenzor.read() * 100);
           ledSig.postaviLedSignalizaciju(temperaturniSenzor);
           wait(0.5);
           }
}

void provjeraSenzora(){
    if(temperaturniSenzor >= 0.9) {
        if(timer.read() == 0){
            timer.start();
            buzzer = 0;
            }
        if(timer.read() >= 2){
            buzzer = 0.5;
        }
    }
    else{
        buzzer = 0;
        timer.reset();
        }
}

void upozorenje() {
    if(debounce.read_ms() > 200) {
        buzzer = 0.1;
        ledSig.upaliSveLedice(2);
        debounce.reset();
        buzzer = 0;
    }
}
