#include "ledSignalizacija.h"

LedSignalizacija::LedSignalizacija(PinName pinGreenLed, PinName pinYelowLed, PinName pinRedLed): _greenLed(pinGreenLed), _yelowLed(pinYelowLed), _redLed(pinRedLed)
{
    _greenLed = 0;
    _yelowLed = 0;
    _redLed = 0;
}

void LedSignalizacija::postaviLedSignalizaciju(float razinaTemperature)
{
    if(razinaTemperature <= 0.5){
        _greenLed.write(1);
        _yelowLed.write(0);
        _redLed.write(0);
        }
    else if(razinaTemperature > 0.5  &&  razinaTemperature < 0.8){
        _greenLed.write(0);
        _yelowLed.write(1);
        _redLed.write(0);
        }
    else {
        _greenLed.write(0);
        _yelowLed.write(0);
        _redLed.write(1);
        }  
}

void LedSignalizacija::upaliSveLedice(int vrijemeRada)
{
        _greenLed.write(1);
        _yelowLed.write(1);
        _redLed.write(1);
        wait(vrijemeRada);
}

