#include "MorseWrite.h"
#include "mbed.h"

MorseWrite::MorseWrite(PinName pin) : _pin(pin){
 _pin = 0;
}

void MorseWrite::write(int message, short n) {
 for(int i=1; i<=n; i++) {
     short symbol = message & 0b11;
     message = message >> 2;
    
     switch(symbol){
        case 0b00:
            _pin = 1;
            wait(duration * dotDuration);
            _pin = 0;
            wait(duration);
            break;
        case 0b01:
            _pin = 1;
            wait(duration * dashDuration);
            _pin = 0;
            wait(duration);
            break;
        case 0b10:
            _pin = 0;
            wait(duration * newLetterDuration);
            break;
        case 0b11:
            _pin = 0;
            wait(duration * spaceDuration);
            break;
    }
 }
} 