#ifndef MONITORINGEXECUTOR_H
#define MONITORINGEXECUTOR_H

#include <map>
#include "mbed.h"
#include "SRF05.h"
#include "configuration.h"
#include "objectPosition.h"


using namespace std;

/*
* This class is used to execute area monitoring operation
*/
class MonitoringExecutor
{
public:
    /**Constructor for MonitoringExecutor*/
    MonitoringExecutor(Configuration* config, Serial* pc, SRF05* ranger, PwmOut* rangerServo, PwmOut* fan, PwmOut* fanServo, DigitalOut* greenLed, DigitalOut* redLed);
    
    /**Destructor for Monitoring executor*/ 
    ~MonitoringExecutor();
    
    /**Start and execute monitoring process*/
    void startMonitoring();

private :
    /**Used to monitor area. Saves the distance and position of all found objects*/
    void findObjects();
    
    /**Directs the fan in the direction of the nearest object in restricted area and activates it.
      *The operating time of the fan is determined by the configuration parameter and the rotation speed of the object distance.
      */
    void activateFan(ObjectPosition* objPos);
    
    /**Converts the servo motor positioning parameter into degrees according to the value set by the configuration*/
    float toDeeg(int angle);
    
    /**Checks if the monitoring duration timer has expired*/
    bool checkMonitoringDurationTimer();
    
    /**Checks if the fan working duration timer has expired*/
    bool checkFanWorkingDurationTimer();

    Configuration* m_config;
    
    map<float, float> m_distancesMap;// <angle, distance>
    Timer m_moitoringDurationTimer;
    Timer m_fanWorkingDurationTimer;

    const static double PI  =3.141592653589793238463;
    
    Serial* m_pc;
    SRF05* m_ranger;
    PwmOut* m_rangerServo;
    PwmOut* m_fan;
    PwmOut* m_fanServo ;
    DigitalOut* m_greenLed ;
    DigitalOut* m_redLed ;
};
#endif
