//libraryji
#include "mbed.h"
#include "LM35.h"
#include "TextLCD.h"


InterruptIn button(USER_BUTTON); //okidač interrupt rutine
Timer debounce;    //timer za istitravanje tastera
TextLCD lcd (PC_8, PB_8, PC_6, PC_5, PA_12, PA_11); //pinovi LCDa
Ticker ledtemp;     //Ticker za blicanje ledice
Timer timer1;       //timer korišten u mainu
DigitalOut led1(PA_10);    //ledica
Serial pc(USBTX, USBRX);    //serijska komunikacija s računalom
LM35 senzor(PC_0);          //senzor temperature
float temperatura2;         //inicijalizacija varijable
void interrupt (void);      //inicijalizacija funkcije
DigitalOut svjetlo(PB_5);   //osvjetljenje LCDa

//interupt funkcija
void interrupt()
{
    if (debounce.read_ms()>200) {

        svjetlo=!svjetlo;
    }

}

//funkcija za blicanje ledica, tj. mijenjanje stanja ledice
void ledica()
{
    led1=!led1;

}


//funkcija za određivanje frekvencije tickera, tj.frekvencije blicanja ledice
void vizualizacija()
{

    if (temperatura2 > 15 && temperatura2 < 20)
        ledtemp.attach(&ledica, 0.5);
    else if (temperatura2> 20 && temperatura2 < 25)
        ledtemp.attach(&ledica, 0.25);
    else if (temperatura2 > 25)
        ledtemp.attach(&ledica, 0.15);
    else  led1=0;


}

//glavna funkcija
int main()
{
    debounce.start();
    timer1.start();
    button.rise(&interrupt);
    while(1) {
        if(timer1.read_ms()>=1000) {
            temperatura2 = senzor.mjerenje();
            lcd.cls ();
            lcd.printf("Temperatura je:", temperatura2);
            lcd.locate (0,1);
            lcd.printf("%.2f C", temperatura2);
            vizualizacija();
            timer1.reset();
        }


    }
}


