#include "manualController.h"

ManualController::ManualController(PinName pinDistance, Serial* pc, SRF05* ranger, PwmOut* rangerServo, PwmOut* fan,PwmOut* fanServo, DigitalOut* greenLed, DigitalOut* redLed):
        m_interruptDistance(pinDistance, PullDown), m_pc(pc), m_ranger(ranger), m_rangerServo(rangerServo), m_fan(fan), m_fanServo(fanServo),
        m_greenLed(greenLed), m_redLed(redLed)
{
    m_interruptDistance.rise(this, &ManualController::hwInterruptReadDistance);
}

void ManualController::executeManualControll()
{
    AnalogIn servoRangerAIn(A1);
    AnalogIn servoFanAIn(A2);
    AnalogIn fanAIn(A3);
    
    while(1) {
        m_rangerServo->pulsewidth_us(500+(2000*servoRangerAIn));
        wait(0.15);
        m_fanServo->pulsewidth_us(500+(2000*servoFanAIn));
        wait(0.15);
        m_fan->pulsewidth_us(20000*fanAIn);
        wait(0.15);
    }   
}

void ManualController::hwInterruptReadDistance() {
    m_pc->printf("Distance: %f\r", m_ranger->read());
}