#include "mbed.h"
#include "Flasher.h"
#include "buzzer.h"

Beep buzzer(D2);
Flasher led1(D4);
Flasher led2(D5);
Flasher led3(D6);
InterruptIn button(USER_BUTTON);
DigitalOut workingLED(LED2);
Timer debounce;
Ticker flipper;

//frekvencija melodija
float a4=440.00;
float b3=246.94;
float b4=493.88;
float c4=261.63;
float c5=523.25;
float c5s=554.40;
float d4=293.66;
float d5=587.33;
float e4=329.63;
float e5=659.25;
float f4=349.23;
float f4s=370.00;
float f5=698.46;
float g4=392.00;
float g4s=415.30;
float g5=783.99;

//trajanje tona
float t1=16;
float t2=8;
float t3=4;
float t4=2;
float t5=1;

//Santa claus is coming to town
float santa_freq[28] = {g4,e4,f4,g4,g4,g4,a4,b4,c5,c5,c5,e4,f4,g4,g4,g4,a4,g4,f4,f4,e4,g4,c4,e4,d4,f4,b3,c4};
float santa_tempo[28] = {t2,t2,t2,t3,t3,t3,t2,t2,t3,t3,t3,t2,t2,t3,t3,t3,t2,t2,t3,t4,t3,t3,t3,t3,t3,t4,t3,t5};

//Jingle Bells
float jingle_freq[26] = {e5,e5,e5,e5,e5,e5,e5,g5,c5,d5,e5,f5,f5,f5,f5,f5,e5,e5,e5,e5,e5,d5,d5,e5,d5,g5};
float jingle_tempo[26] = {t2,t2,t3,t2,t2,t3,t2,t2,t2,t2,t4,t2,t2,t2,t2,t2,t2,t2,t1,t1,t2,t2,t2,t2,t3,t3,};

//We wish you a merry Christmas
float wish_freq[30] = {e4,a4,a4,b4,a4,g4s,f4s,f4s,f4s,b4,b4,c5s,b4,a4,g4s,e4,e4,c5s,c5s,d5,c5s,b4,a4,f4s,e4,e4,f4s,b4,g4s,a4};
float wish_tempo[30] = {t3,t3,t2,t2,t2,t2,t3,t3,t3,t3,t2,t2,t2,t2,t3,t3,t3,t3,t2,t2,t2,t2,t3,t3,t2,t2,t3,t3,t3,t4};

float time_delay = 0.5;
void flip(void);
void interrupt(void);

int main()
{
    debounce.start();
    button.rise(&interrupt);
    flipper.attach(&flip,time_delay);
    int i,j;

    while(1) {

        for(i=0; i<28; i++) {
            buzzer.beep(santa_freq[i], santa_tempo[i]);
            led1.flash(1);
            led2.flash(1);
            led3.flash(1);
            wait(1/santa_tempo[i]);
        }
        wait(1);

        for(j=0; j<2; j++) {
            for(i=0; i<26; i++) {
                buzzer.beep(jingle_freq[i], jingle_tempo[i]);
                led1.flash(1);
                led2.flash(1);
                led3.flash(1);
                wait(1/jingle_tempo[i]);
            }
        }
        wait(1);

        for(i=0; i<30; i++) {
            buzzer.beep(wish_freq[i], wish_tempo[i]);
            led1.flash(1);
            led2.flash(1);
            led3.flash(1);
            wait(1/wish_tempo[i]);
        }
        wait(2);
    }
}

void flip()
{
    workingLED = !workingLED;
}

//Zaustavlja rad na 5 sec
void interrupt()
{

    if (debounce.read_ms()>200) {
        wait_us(5000000);
    }
    debounce.reset();
}
