#include "mbed.h"
#include "On_Off.h"
Serial pc(USBTX, USBRX);
DigitalOut led1(A0);
LED led2(A1);
DigitalOut led3(A2);

Ticker tiktok;

InterruptIn dugme(USER_BUTTON);
Timer trajanje;
Timer debounce;

BusInOut inputSW(D10, D11, D12);


BusOut Seg1(D2,D3,D4,D5,D6,D7,D8,D9);
char SegConvert(int SegValue);

int *RNGf (int g);
int RNG;

int *defuse (int d);


void Blink ()
    {
    led2.flip();
    }

void stop()
{
    if(debounce.read_ms()>200) {
        while (trajanje.read_ms()<10000)
            {
                trajanje.start();
                led1=1;
                led3=1;
            }
            led1=0;
            led3=0;
            trajanje.stop();
            trajanje.reset();
    }
    debounce.reset();
}


int main()
{
srand(time(NULL));
debounce.start();

dugme.rise(&stop);

inputSW.mode(PullUp);

tiktok.attach(&Blink,0.2);

int *returned;
int *spas;
int a, b, c, t, z, u, v, n, m;
int k=0;
int i;
    while (1) {
        spas = defuse(inputSW);
    switch (k)
        {
        case 0: {
            RNG = rand() % 8;
            Seg1=SegConvert(RNG);
            returned = RNGf(RNG);
            a = returned[0];
            b = returned[1];
            c = returned[2];
            led1=0;
            led3=0;
            wait(5);
            k=1;
            break;
            }
        case 1: {
            int brojac=9;
            for (i=9;i>-1;i--){
                Seg1=SegConvert(i);
                
                spas = defuse(inputSW);
                t = spas[0];
                z = spas[1];
                u = spas[2];
                if (t != 0 || z != 0 || u != 0)
                {k=3;
                break;
                }
                
                brojac--;
                wait(1);
                }
                if (k == 3)
                break;
                if (brojac <= 0)
                {k=2; 
                break; 
                }
                             
                }
                
        case 2: {
            led1=0;
            led3=1;
            k=0;
            wait(3);
            break;
            }
            
        case 3: {
            spas = defuse(inputSW);
            t = spas[0];
            z = spas[1];
            u = spas[2];
            
            if(a+b+c == 0)
            {
                led1=0;
                led3=1;
            }
            
            if(a+b+c==1)
            {
               v=a-u;
               n=b-z;
               m=c-t;
               if(abs(v)+abs(n)+abs(m) == 0)
               {
                    led1=1;
                    led3=0; 
                }
                else
                {
                    led1=0;
                    led3=1;
                 }
            }
            
            if(a+b+c==2)
            {
               v=a-u;
               n=b-z;
               m=c-t;
               if(abs(v)+abs(n)+abs(m) == 3)
               {
                    led1=1;
                    led3=0; 
                }
                else
                {
                    led1=0;
                    led3=1;
                 }
            }
            
            if(a+b+c == 3)
            {
                led1=1;
                led3=0;
            }
            
            if (t == 0 && z == 0 && u == 0)
            {k=0;
            pc.printf("if\n\r");
            break;
            }
            
            }
        }
    }
}

int *RNGf (int g)
{   
    int ar[3];
    switch (g) {
        case 0: {
            ar[0]=0;
            ar[1]=0;
            ar[2]=0;
            break;
        }
        case 1: {
            ar[0]=0;
            ar[1]=0;
            ar[2]=1;
            break;
        }
        case 2: {
            ar[0]=0;
            ar[1]=1;
            ar[2]=0;
            break;
        }

        case 3: {
            ar[0]=0;
            ar[1]=1;
            ar[2]=1;
            break;
        }

        case 4: {
            ar[0]=1;
            ar[1]=0;
            ar[2]=0;
            break;
        }

        case 5: {
            ar[0]=1;
            ar[1]=0;
            ar[2]=1;
            break;
        }
        case 6: {
            ar[0]=1;
            ar[1]=1;
            ar[2]=0;
            break;
        }

        case 7: {
            ar[0]=1;
            ar[1]=1;
            ar[2]=1;
            break;
        }

    }
        return ar;

}

char SegConvert(int SegValue) {
 char SegByte=0x00;
 switch (SegValue) {
 case 0 : SegByte = 0x3F;break; 
 case 1 : SegByte = 0x06;break;
 case 2 : SegByte = 0x5B;break;
 case 3 : SegByte = 0x4F;break; 
 case 4 : SegByte = 0x66;break;
 case 5 : SegByte = 0x6D;break;
 case 6 : SegByte = 0x7D;break;
 case 7 : SegByte = 0x07;break;
 case 8 : SegByte = 0x7F;break;
 case 9 : SegByte = 0x6F;break;
 }
 return SegByte;
}

int *defuse (int d)
{   
    int ar[3];
    switch (d) {
        case 0x1: {
            ar[0]=1;
            ar[1]=0;
            ar[2]=0;
            break;
        }
        case 0x2: {
            ar[0]=0;
            ar[1]=1;
            ar[2]=0;
            break;
        }
        case 0x4: {
            ar[0]=0;
            ar[1]=0;
            ar[2]=1;
            break;
        }

        default: {
            ar[0]=0;
            ar[1]=0;
            ar[2]=0;
            break;
        }

    }
        return ar;
}
