#include "mbed.h"
#include "TextLCD.h"
#include "ventilator.h"

TextLCD lcd(A4, A5, D4, D5, D6, D7);  //definiramo pinove koji ce se koristiri za lcd
VENTILATOR ventilator1(D3);  
AnalogIn potencio(A1);   //definiramo da pin A1 bude analogni ulaz
DigitalIn start(D8);   //definiramo da pin D8 bude digitalni ulaz
Timer ven_on;   //definiramo timer
float vrijednost_pot;   //definiramo farijablu tipa float u koju ćemo spremiti vrijednost potenciometra

int main()
{
    start.mode(PullUp);
    while(1){   // beskonacna petlja
        vrijednost_pot=potencio*100;   
        lcd.printf("Temp: %.2f C",vrijednost_pot);
        wait(0.2);
        if(vrijednost_pot>=60){
            while(vrijednost_pot > 25){
                vrijednost_pot=potencio*100;
                lcd.printf("Temp: %.2f C",vrijednost_pot);
                wait(0.2);
                ventilator1.stanje(1);   //pozivanje i slanje vrijednosti za funkciju stanje
                lcd.cls();
                }
        }
        if(vrijednost_pot<60){
            ventilator1.stanje(0);
        }
        if(start==0){
            ven_on.start();   //pokretanje timera
            while(ven_on.read_ms()<5000){    //petlja koja određeno vrijeme pokrece ventilator
                ventilator1.stanje(1);
            }
            ventilator1.stanje(0);
            ven_on.stop();   //zaustavljanje timera
            ven_on.reset();   //resetiramo timer
        }
        lcd.cls();
    }
}
