#include "mbed.h"
#include "Blink.h"
//Definiranje ulaza
InterruptIn button(USER_BUTTON);

//Definiranje tajmera
Timer debounce;
Timer Prekid1;
Timer Prekid2;
Ticker flipper;

//Definifanje izlaza
LED led1(D11);
LED led2(D12);
LED led3(D13);
LED led4(D14);
LED led5(D15);
BusOut Seg1(D2,D3,D4,D5,D6,D7,D8,D9);

//Definiranje funkcija
char SegConvert(int SegValue);
void Binary (int g);
void prekid(void);

//Funkcija upravljanja s 7 segmentnim displeom
char SegConvert(int SegValue) {
 char SegByte=0x00;
 switch (SegValue) {
 case 0 : SegByte = 0x3F;break; 
 case 1 : SegByte = 0x06;break;
 case 2 : SegByte = 0x5B;break;
 case 3 : SegByte = 0x4F;break; 
 case 4 : SegByte = 0x66;break;
 case 5 : SegByte = 0x6D;break;
 case 6 : SegByte = 0x7D;break;
 case 7 : SegByte = 0x07;break;
 case 8 : SegByte = 0x7F;break;
 case 9 : SegByte = 0x6F;break;
 }
 return SegByte;
}

//Funkcija prekida
void prekid()
{
    if(debounce.read_ms()>200){
        led1.status(0);
        led2.status(0);
        led3.status(0);
        led4.status(0);
          while(Prekid1.read()<=10){
             Prekid1.start();
             Prekid2.start();
             if(Prekid2.read_ms()>=500)
             {
             led1.flip();
             Prekid2.stop();
             Prekid2.reset();
             }
            }
        Prekid1.stop();
        Prekid1.reset();
        }
        debounce.reset();
}

//Funkcija odredivanja stanja LED
void Binary (int g)
{   
    switch (g) {
        case 0: {
            break;
        }
        case 1: {
            led1.flip();
            break;
        }
        case 2: {
            led2.flip();
            break;
        }
        case 3: {
            led1.flip();
            led2.flip();
            break;
        }
        case 4: {
            led3.flip();
            break;
        }
        case 5: {
            led1.flip();
            led3.flip();
            break;
        }
        case 6: {
            led3.flip();
            led2.flip();
            break;
        }
        case 7: {
            led1.flip();
            led2.flip();
            led3.flip();
            break;
        }
        case 8: {
            led4.flip();
            break;
        }
         case 9: {
            led1.flip();
            led4.flip();
            break;
        }
    }
}

//funkcija Ticker-a
void flip(){
    led5.flip();   
}

//main funkcija
int main()
{
    debounce.start();
    button.rise(&prekid);  
    flipper.attach(&flip,0.2);
    int i;
    while(1){
        for (i=0;i<10;i++){
        led1.status(0);
        led2.status(0);
        led3.status(0);
        led4.status(0);
        Seg1=SegConvert(i);
        Binary(i);
        wait_ms(1000);
        }        
    }            
}
