#include "mbed.h"
#include <ADXL345.h> 

class XYZ{ 
        public:
        float x;
        float y;
        float z;
        
        void normalise(int* raw_data){ 
                x = float(int16_t(raw_data[0]))*4/1000; 
                y = float(int16_t(raw_data[1]))*4/1000; 
                z = float(int16_t(raw_data[2]))*4/1000; 
            }
    };

ADXL345 adxl345(D11, D12, D13, D10); 
InterruptIn externalInterrupt(D15); 
Serial pc(USBTX, USBRX); 
DigitalOut RedLed(D6); 
DigitalOut GreenLed(D5); 
Ticker tick; 
int data[3];  
XYZ acc; 

void freeFallDetect(){
        RedLed = 1;
        wait(0.1);
        RedLed = 0; 
        pc.printf("Free fall detected\r\n"); 
        adxl345.getInterruptSource(); 
        return;
    }
    
void fetchData(){ 
        GreenLed = !GreenLed; 
        adxl345.getOutput(data); 
        acc.normalise(data);
        pc.printf("--X = %fg, Y = %fg, Z = %fg--\r\n", acc.x, acc.y, acc.z);
        return;
    }

int main(){
    
    adxl345.setPowerControl(0x08); 
    adxl345.setDataFormatControl(0x08); 
    adxl345.setInterruptMappingControl(0xFB);
    adxl345.setFreefallThreshold(0x09);
    adxl345.setFreefallTime(25); 
    adxl345.setInterruptEnableControl(0x04);
    adxl345.getInterruptSource();
    
    externalInterrupt.rise(&freeFallDetect); 
    tick.attach(&fetchData, 0.2); 

    while (true) {
        __WFI(); 
    }
}
