#include "mbed.h"

InterruptIn BUTTON(PA_10); // button otvori
InterruptIn BUTTON2(PB_3); // button zatvori
DigitalOut DOOR_STATE(PB_5); // otvorenost vrata (0-zatvoreno/1-otvoreno)
DigitalOut LED(PB_4); // led koji provjerava izvodi li se main program (led treperi-main se izvodi)
Ticker CHECK; // provjera izvodi li se main program
Timer timer1; // timer - otvaranje
Timer timer2; // timer - zatvaranje
Timer debounce1; // debounce timer - otvaranje
Timer debounce2; // debounce timer - zatvaranje
void open(void); // funkcija otvaranje
void close(void); // funkcija zatvaranje

void MAIN_CHECK ()
{
    if (LED==0) {
        LED=1;
    } else {
        LED=0;
    }
}

int main()
{
    debounce1.start();
    BUTTON.mode(PullUp);
    debounce2.start();
    BUTTON2.mode(PullUp);

    BUTTON.fall(&open);
    BUTTON2.fall(&close);

    CHECK.attach(&MAIN_CHECK,2);

}

void open()
{
    if (DOOR_STATE==0) {
        if(debounce1.read_ms()>=200) {
            timer1.start();
            while (timer1.read_ms()<=5000) {
                DOOR_STATE=0;
                wait(0.40);
                DOOR_STATE=1;
                wait(0.40);
            }
            DOOR_STATE=1;
            timer1.stop();
            timer1.reset();
        }
        debounce1.reset();
    } else {
        DOOR_STATE=1;
    }
}


void close()
{
    if (DOOR_STATE==1) {
        if(debounce2.read_ms()>=200) {
            timer2.start();
            while (timer2.read_ms()<=5000) {
                DOOR_STATE=0;
                wait(0.40);
                DOOR_STATE=1;
                wait(0.40);
            }
            DOOR_STATE=0;
            timer2.stop();
            timer2.reset();
        }
        debounce2.reset();
    } else {
        DOOR_STATE=0;
    }
}