#include "svjetla.h"
#include "segmentni.h"
#include "buzzer.h"

DigitalOut red(PC_0);
DigitalOut yellow(PC_1);
DigitalOut green(PC_2);
DigitalOut pjesaciLed(LED2);

Timer debounce;
Timer timerPjesaci;
Serial pc(USBTX, USBRX);
Buzz buzzer(PC_9);

void semafor()
{
    stop();
    wait(3);
    dopunsko();
    wait(3);
    SegConvert(11);
    pripremi();
    wait(1);
    kreni();
    wait(3);
    uspori();
    wait(1);
}

void stop()
{
    red = 1;
    yellow = 0;
    green = 0;
    pc.printf("Crveno \n \r");
}

void pripremi()
{
    red = 1;
    yellow = 1;
    green = 0;
    pc.printf("Zuto \n \r");
}

void kreni()
{
    red = 0;
    yellow = 0;
    green = 1;
    pc.printf("Zeleno \n \r");
}

void uspori()
{
    pc.printf("Zuto \n \r");
    red = 0;
    yellow = 1;
    green = 0;
}

void dopunsko()
{
    pc.printf("Dopunsko \n \r");
    SegConvert(10);
}

void funkcijaPjesaci()
{
    debounce.start();
    if (debounce.read_ms()>200) {
        stop();
        pjesaci();
        debounce.reset();
    }
}

void pjesaci()
{
    pc.printf("Pjesaci \n \r");
    timerPjesaci.start();
    int vrijeme = 0;
    while (timerPjesaci.read()<=10) {
        vrijeme = 10 - timerPjesaci.read();
        treperenje();
        SegConvert(vrijeme);
        buzzer.buzz();
        wait(0.5);
    }
    buzzer.buzzOff();
    SegConvert(11);
    timerPjesaci.stop();
    timerPjesaci.reset();
}

void treperenje()
{
    pjesaciLed =! pjesaciLed;
}

void kvar()
{
    red = 0;
    yellow =! yellow;
    green = 0;
}