#include "buzzer.h"

AnalogIn potenciometar(PA_0);

Buzz::Buzz(PinName pin) : _pwm(pin)
{
    _pwm = 0;
}

void Buzz::buzzOff()
{
    _pwm = 0.0;
}

void Buzz::buzz()
{
    float frekvencija = potenciometar * 1000;
    if(frekvencija == 0) {
        buzzOff();
    } else if(frekvencija != 0) {
        _pwm.period(1.0 / frekvencija);
        _pwm = 0.5;
    }

}