#include "mbed.h"
#include "Veza_s_racunalom.h"


AnalogIn Ain0(A0);  //Mjerena temperatura (pot)
AnalogIn Ain1(A1);  //Postavna temperatura (pot)
InterruptIn Start(D2);  //Tipka za start
InterruptIn Stop(D3);  //Tipka za stop
InterruptIn AlarmOFF(D4);  //Tipka za potvrdu alarma
InterruptIn Pozar(D8);  //Signal s detektora pozara (tipkalo)
DigitalOut ISKLJUCENO(D13);  //RGB LED - CRVENO
DigitalOut UKLJUCENO(D12);  //RGB LED - ZELENO
PwmOut Zvucnik(D9);  //Izlaz na buzzer
PwmOut Motor(D10);  //Upravljački signal


Timer debounce;  //Timer za debounce

Ticker slanje;  //Ticker za periodično slanje podataka na PC
Ticker alarmi;  //Ticker za upravljanje alarmiranjem



float MjTemp,ZelTemp;  //Varijable mjerene i zeljene temperature
int ModRada;  //Varijabla moda rada (1=RAD,0=ISK,2=POZAR)
int zvuk;  //Pomocna varijabla za izmjenicni zvuk alarma

void inicijalizacija(){  //inicijalizacija pocetnog stanja
     UKLJUCENO=0;
     ISKLJUCENO=1;
     ModRada=0;
     
     }
class Zmigaj  //Klasa postavljanja alarmnog izlaza
{                          //Definiranje izlaza alarma
public: 
     Zmigaj(PinName pin) : _pin(pin) 
     { 
      
     _pin = 0;     
 }
     void zmigni() 
     { 
        _pin = !_pin;        
     } 
 
private: 
     DigitalOut _pin;     
    }; 

Zmigaj ALARM(D11);  

void ZvukAlarma (){  //Definiran zvuk alarma
    if (zvuk==0){
            Zvucnik.period(0.003f);
            Zvucnik.write(0.50f);
            zvuk=1;}    
     else if (zvuk==1){
             Zvucnik.period(0.004f);
             Zvucnik.write(0.50f);
             zvuk=0;
             } 
     } 
     
void AlarmON(){                   //Funkcija za svjetlo i zvuk alarma
        if (ModRada==2){
        ALARM.zmigni();
         ZvukAlarma(); 
        }         
             
}

void Ispis (void){  
    if (ModRada==1){                    //Slanje info na računalo
        Slanje(MjTemp,ZelTemp);
        }
    }
    


void ModAlarm (){                       //Funkcija za paljenje alarma
        if (debounce.read_ms()>200){       
            ModRada=2 ;
            UKLJUCENO=0;
            ISKLJUCENO=0;
            pc.printf("DETEKTIRAN POZAR\n\r"); 
            pc.printf("ALARM UKLJUCEN!!!\n\r");    
            debounce.reset();
        }
    }
    
void GasiAlarm (){                      //Funkcija za gašenje alarma
        if ((debounce.read_ms()>200)&(ModRada==2)){       
            ModRada=0 ;
            UKLJUCENO=0;
            ISKLJUCENO=1;
            Zvucnik=0;
            pc.printf("ALARM ISKLJUCEN\n\r");     
            pc.printf("SUSTAV ISKLJUCEN\n\r");
            debounce.reset();
        }
    }
    
void UpaliPogon (){  //Funkcija za pokretanje regulacije
        if ((debounce.read_ms()>200)&(ModRada==0)){       
            ModRada=1 ;
            UKLJUCENO=1;
            ISKLJUCENO=0;
            pc.printf("SUSTAV UKLJUCEN\n\r");                
            debounce.reset();
        }
    }
    
void UgasiPogon (){  //Funkcija za iskljucivanje regulacije
        if ((debounce.read_ms()>200)&(ModRada==1)){       
            ModRada=0 ;
            UKLJUCENO=0;
            ISKLJUCENO=1;
            pc.printf("SUSTAV ISKLJUCEN\n\r");
            debounce.reset();
        }
    }

int main() {
    Motor.period(0.01); //Postavljen fiksan period pwm-a za motor
    inicijalizacija();  //Postavljanje početnih uvjeta sustava
    debounce.start();   //Debounce timer
    Pozar.rise(&ModAlarm);  //Interrupt koji stvara detektor požara
    slanje.attach(&Ispis, 1);  //Ispis podataka na računalo pomocu ticker-a
    alarmi.attach(&AlarmON,0.2);  //Definicija zvuka i svjetlosnog signala alarma
    AlarmOFF.rise(&GasiAlarm);  //Interrupt tipke za isklj. alarma
    Start.rise(&UpaliPogon);  //Interrupt tipke za pokretanje regulacije
    Stop.rise(&UgasiPogon);  //Interrupt tipke za iskljucivanje regulacije 
    float delta;  //Varijabla za racunanje razlike izmedu Zelj i Mjereno
    float dutycycle; 
    while (1) {        
        if (ModRada==1){   //ModRada = 1 znaci da je regulacija ukljucena                  
            ZelTemp=Ain1*22+18;  //Postavna temperatura (pot) od 18 - 40 °C
            MjTemp=Ain0*40;  //Mjerena temperatura (pot) od 0 - 40°C
            delta = abs(int(ZelTemp)-int(MjTemp));  //Razlika Mj i Zel
            if (delta <1) {  //Mrtva zona
                dutycycle=0;}
            else{
            dutycycle=(delta*2.5)/100;  //Regulacija izlaza s obzirom na razliku
                 }   
            }
            else  dutycycle=0; 
        Motor.write(dutycycle);  //Upravljacki signal                
    }
}