#include"mbed.h"
DigitalOut LEDcrvena(D7); //LED svjetlo za vozila
DigitalOut LEDzuta(D6);     //LED svjetlo za vozila
DigitalOut LEDzelena(D5);   //LED svjetlo za vozila

DigitalOut LEDzelenapjesaci(D2);    //LED svjetlo za pješake
DigitalOut LEDcrvenapjesaci(D3);    //LED svjetlo za pješake

PwmOut z(D9);               //PWM izlaz za zvučnik
InterruptIn tipkalo(D4);    //Tipkalo za pješake

Ticker zv;              //Ticker za pozivanje zvuka
Timer debounce;         //Timer za debounce
void pjesaci(void);     //definiranje funkcije pjesaci
void zvuk(void);        //definiranje funkcije zvuk

int main()
{
    debounce.start();
    tipkalo.rise(&pjesaci);  //pozivanje funkcije "pjesaci" koja odmah pali zeleno svjetlo za pješake, ukoliko je uključeno zeleno za vozila

    while(1) {
        zv.attach(&zvuk, 0.5);

        LEDcrvena=1;
        LEDcrvenapjesaci=1;
        LEDzuta=0;
        LEDzelena=0;
        LEDzelenapjesaci=0;
        wait(1);              //crveno svjetlo vozilima, sigurnosni prijelaz između svjetla za vozila i pješake

        LEDcrvena=1;
        LEDcrvenapjesaci=0;
        LEDzuta=0;
        LEDzelena=0;
        LEDzelenapjesaci=1;
        wait(12);       //zeleno za pješake

        LEDcrvena=1;
        LEDcrvenapjesaci=1;
        LEDzuta=0;
        LEDzelena=0;
        LEDzelenapjesaci=0;
        wait(1);        //pali se crvena za pješake, priprema za žuto odnosno zeleno svjetlo vozilima

        LEDcrvena=1;
        LEDcrvenapjesaci=1;
        LEDzuta=1;
        LEDzelena=0;
        LEDzelenapjesaci=0;
        wait(3);        //pali se žuto svjetlo - priprema za kretanje vozila

        LEDcrvena=0;
        LEDcrvenapjesaci=1;
        LEDzuta=0;
        LEDzelena=1;
        LEDzelenapjesaci=0;
        wait(15);       //zeleno svjetlo vozilima

        LEDcrvena=0;
        LEDcrvenapjesaci=1;
        LEDzuta=1;
        LEDzelena=0;
        LEDzelenapjesaci=0;
        wait(4);        //pali se žuto svjetlo, upozorenje da slijedi crveno svjetlo
    }
}
void pjesaci()
{
    if(debounce.read_ms()>200) {
        if(LEDzelena==1) {      //ako je zeleno svjetlo za vozila uključeno

            z.period(0.5);
            z=0.5;
            wait(2);        //nakon pritiska tipke, zeleno svjetlo svjetli još 2 sekunde

            LEDcrvena=0;
            LEDcrvenapjesaci=1;
            LEDzuta=1;
            LEDzelena=0;
            LEDzelenapjesaci=0;
            z.period(0.5);
            z=0.5;                 //zvuk za crveno svjetlo pjesacima
            wait(4);            //pali se žuto svjetlo, priprema za crveno

            LEDcrvena=1;
            LEDcrvenapjesaci=1;
            LEDzuta=0;
            LEDzelena=0;
            LEDzelenapjesaci=0;
            z.period(0.5);
            z=0.5;          //zvuk za crveno svjetlo pjesacima
            wait(1);        //crveno svjetlo vozilima, sigurnosni prijelaz između svjetla za vozila i pješake

            LEDcrvena=1;
            LEDcrvenapjesaci=0;
            LEDzuta=0;
            LEDzelena=0;
            LEDzelenapjesaci=1;
            z.period(0.1);
            z=0.5;              //zvuk za zeleno svjetlo pjesacima
            wait(6);            //upalilo se crveno svjetlo vozilima, zeleno je pješacima

            LEDcrvena=1;
            LEDcrvenapjesaci=1;
            LEDzuta=0;
            LEDzelena=0;
            LEDzelenapjesaci=0;
            z.period(0.5);
            z=0.5;              //zvuk za crveno svjetlo pjesacima
            wait(1);           //pali se crveno pješacima

            LEDcrvena=1;
            LEDcrvenapjesaci=1;
            LEDzuta=1;
            LEDzelena=0;
            LEDzelenapjesaci=0;
            z.period(0.5);
            z=0.5;              //zvuk za crveno svjetlo pjesacima
            wait(4);            //uz crveno pješacima, pali se žuto svjetlo, priprema za zeleno za vozila

            LEDcrvena=0;
            LEDcrvenapjesaci=1;
            LEDzuta=0;
            LEDzelena=1;
            LEDzelenapjesaci=0;
            z.period(0.5);
            z=0.5;              //zvuk za crveno svjetlo pjesacima
            wait(15);           //pali se zeleno svjetlo za vozila

            LEDcrvena=0;
            LEDcrvenapjesaci=1;
            LEDzuta=1;
            LEDzelena=0;
            LEDzelenapjesaci=0;
            z.period(0.5);
            z=0.5;              //zvuk za crveno svjetlo pjesacima
            wait(4);            //pali se žuto svjetlo, priprema za crveno svjetlo vozilima

        }
        debounce.reset();
    }
}
void zvuk()
{
    if(LEDzelenapjesaci==1) {
        z.period(0.1); // definiranje PWM perioda za zvučnik --> zvuk za zeleno svjetlo pjesacima
        z=0.5;  //aktivni ciklus na 50%, PWM frekvencija definira visinu reproduciranog zvuka
    } else if(LEDzelenapjesaci==0) {
        z.period(0.5);      //zvuk za crveno svjetlo pjesacima
        z=0.5;          
    }
}
