#include "mbed.h"
#include "ledice.h"

//Serial pc(USBTX, USBRX);

//Timer timer;
Ticker kontrolniUlazT;
InterruptIn button(D7, PullDown);
Timer debounce;
Ledice ledice(D4, D3, D2);


DigitalIn ulazZelena(D5);
DigitalIn ulazZuta(D6);
DigitalIn ulazCrvena(D8);
DigitalIn ulazKont(D9);

void provjeraKontrolnogUlazaT();
void prekid();

int main()
{
   debounce.start();
   button.rise(&prekid);    
   kontrolniUlazT.attach(&provjeraKontrolnogUlazaT, 0.5);
   ulazZelena.mode(PullDown);
   ulazZuta.mode(PullDown);
   ulazCrvena.mode(PullDown);
   ulazKont.mode(PullDown);
   
   while(1){
           ledice.postaviLedice(ulazZelena, ulazZuta, ulazCrvena);
           wait(0.2);
           }
}

void provjeraKontrolnogUlazaT(){
    if(ulazKont == 1) {
        ledice.upaliSveLedice(1);
    }
}

void prekid() {
    if(debounce.read_ms() > 200) {
        ledice.upaliSveLedice(1.5);
        debounce.reset();
    }
}
