#include "mbed.h"
#include "buzzer.h"
#include "led.h"
#include <stdio.h>
#include <ctype.h>

//HW komponente
InterruptIn button(USER_BUTTON);//p18
Serial pc(USBTX, USBRX);
Beep buzzer(D2);//p21
LED dotLED(D3);//p5
LED dashLED(D4);//p6
LED interruptLED(D5);//p7
DigitalOut workingLED(LED1);
Timer debounce;
Ticker flipper;

//Inicijalizirane vrijednosti za buzzer i led
float time_delay = 1;
float timeDot = 0.25;
float timeDash = 0.75;
float freqDot = 659.3; // ton za Dot
float freqDash = 440.0; // ton za Dash

//Prototipi funkcija
void flip(void);
void interrupt(void);
void clearAndHomeSerial(void);
void buzzerDot(void);
void buzzerDash(void);
void dot(void);
void dash(void);
void morseCoder(char sign);


int main()
{
    debounce.start();
    button.rise(&interrupt);
    flipper.attach(&flip,time_delay);

    while(1) {
        char sentence[50];
        pc.printf("Unesite recenicu: ");
        char c;
        int i=0;
        while(1) {
            c = pc.getc();
            if(c==8) {
                i--;
                continue;
            }
            pc.printf("%c",c);
            if(c==13) {
                break;
            }
            sentence[i]=tolower(c);
            i++;

        }
        pc.printf("\r\n");

        int size = i;
        char newSentence[size];
        for(i=0; i<size; i++) {
            newSentence[i]=sentence[i];
        }

        pc.printf("Upisana recenica : ");
        for(i=0; i<size; i++) {
            pc.printf("%c",newSentence[i]);
        }
        pc.printf("\r\n");
        pc.printf("Kodirana recenica: ");

        for(i=0; i<sizeof(newSentence); i++) {
            morseCoder(newSentence[i]);
        }
        wait(5);
        clearAndHomeSerial();
    }
    return 0;
}

//Funkcija mijenja stanje LED-ice koja označava rad programa
void flip(){
    workingLED = !workingLED;
    }

//Funkcija koja se poziva nakon pritiska interrupt buttona
void interrupt()
{

    if (debounce.read_ms()>200) {
        interruptLED.flip();
        wait_us(5000000);
        interruptLED.flip();
    }
    debounce.reset();
}

//Funkcija koja čisti ekran terminala
void clearAndHomeSerial()
{
//Serial Terminal
    pc.printf("%c",char(27)); // ESC
    pc.printf("[2J"); // clear screen
    pc.printf("%c",char(27)); // ESC
    pc.printf("[H"); // cursor to home
}

//Funkcija poziva beep metodu za buzzer sa parametrima frekvencije i vremenskog perioda trajanja točke (dot)
void buzzerDot()
{
    buzzer.beep(freqDot,timeDot);
}

//Funkcija poziva beep metodu za buzzer sa parametrima frekvencije i vremenskog perioda trajanja crte (dash)
void buzzerDash()
{
    buzzer.beep(freqDash,timeDash);
}

//Funkcija pali i gasi LED i buzzer u periodu koji je određen za točku (dot)
void dot()
{
    pc.printf(".");
    dotLED.flip();
    buzzerDot();
    wait(timeDot);
    dotLED.flip();
}

//Funkcija pali i gasi LED i buzzer u periodu koji je određen za crtu (dash)
void dash()
{
    pc.printf("-");
    dashLED.flip();
    buzzerDash();
    wait(timeDash);
    dashLED.flip();
}

//Funkcija dobiva znak te pokreće te isti prevodi u Morse abecedu, i sukladno tome pokreće metode vezane uz prikaz
void morseCoder(char sign)
{

    switch (sign) {
        case 'a':
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'b':
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'c':
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'd':
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'e':
            dot();
            wait(time_delay);
            break;
        case 'f':
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'g':
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'h':
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'i':
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'j':
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'k':
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'l':
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'm':
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'n':
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'o':
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'p':
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 'q':
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'r':
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 's':
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case 't':
            dash();
            wait(time_delay);
            break;
        case 'u':
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'v':
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'w':
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'x':
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'y':
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            break;
        case 'z':
            dash();
            wait(time_delay);
            dash();
            wait(time_delay);
            dot();
            wait(time_delay);
            dot();
            wait(time_delay);
            break;
        case ' ':
            pc.printf(" ");
            wait(time_delay);
            break;
    }
}