#include "mbed.h"
#include "SegDisplay.h"
InterruptIn button1(PA_5); //Interrupt pin
InterruptIn button2(PA_6); //Interrupt pin
Serial pc(USBTX, USBRX); //Serijska komunikacija s računalom
DigitalOut greenLED(PA_10);
DigitalOut yellowLED(PB_3);
DigitalOut redLED(PB_5);
Ticker blink; //Ticker za blinkanje ledice
Timer debounce; //Timer za micanje debouncinga
void toggle(void); //inicijalizacija funkcije
void toggle2(void); //inicijalizacija funkcije
void Upozorenje(void); //inicijalizacija funkcije
int gear=1;  // inicijalizacija varijable
int brzinaOkretaja=0; // inicijalizacija varijable

void redBlink()
{
    redLED=!redLED;

}

//Funkcija za upozorenje kada je idealno za promijeniti brzinu
void Upozorenje()
{
    if(brzinaOkretaja>=4500 && brzinaOkretaja < 5500) {
        greenLED=1;
        yellowLED=0;
        redLED=0;
    } else if(brzinaOkretaja>=5500 && brzinaOkretaja < 7000) {
        greenLED=1;
        yellowLED=1;
        redLED=0;
    } else if(brzinaOkretaja>=6500 && brzinaOkretaja < 7500) {
        greenLED=1;
        yellowLED=1;
        redLED=1;
    } else if(brzinaOkretaja<4500 || brzinaOkretaja>=9000){
        greenLED=0;
        yellowLED=0;
        redLED=0;
        }    
    return;
}

int main()   //Glavni program
{
    debounce.start();
    SegInit(); // Pozivanje funkcije za inicijalizaciju 7 seg. displaya
    while (brzinaOkretaja <= 9000 && gear <=6) { // infinite loop
        //brzina=(Ain/3.3)*9000;
        brzinaOkretaja = brzinaOkretaja + 100;
        pc.printf("Brzina okretaja: %d\n\r", brzinaOkretaja); // Ispis trenutne brzine okretaja
        wait(0.15);
        button1.rise(&toggle); // Prebacivanje u višu brzinu
        button2.rise(&toggle2); // Prebacivanje u nižu brzinu
        Upozorenje();
        Seg1 = SegConvert(gear); // Pozivanje funkcije za ispis na 7 seg. displayu
    }
    blink.attach(&redBlink, 0.25); // Blinkanje ledice pomoću tickera
    pc.printf("Zakucali ste motor u blokadu, auto se gasi!!!");
    wait(5);
    blink.detach();
}

//Interrupt za prebaciti u višu brzini
void toggle()
{
    if (debounce.read_ms()>200) { // only allow toggle if debounce timer
        gear=gear+1; // has passed 200 ms
        brzinaOkretaja=brzinaOkretaja-3000;
    }
    debounce.reset(); // restart timer when the toggle is performed
}

//Interrupt za prebaciti u nizu brzinu
void toggle2()
{
    if (debounce.read_ms()>200){
        gear=gear-1; // 
        brzinaOkretaja=brzinaOkretaja+1500;
    }
    debounce.reset();
}









