#include "mbed.h"
#include "TextLCD.h"
#include "HX711.h"

TextLCD lcd(PA_10, PB_3, PB_5, PB_4, PB_10, PA_8); //inicijacija 20x4 LCD-a
HX711 scale(A1,A0,64); //inicijacija modula za ocitavanje mase

DigitalIn tariranje(PC_7); //ulaz na kojeg je spojeno tipkalo za postavljanje vage u 0

DigitalOut on(PB_6); //izlaz za ON LED-icu
DigitalOut pnp(PA_7); //izlaz za LED-icu dok traje ocitanje
Ticker ocitanje; //ticker a LED-icu dok traje ocitanje
DigitalOut alarm(PA_6); //izlaz za LED-icu detekcije prekoracenja mase na vagi
Ticker prekoracenje; // ticker za LED-icu detekcije prekoracenja mase na vagi

InterruptIn tipkakonverzije(PA_9); //prekidni pin za tipkalo pomocu kojeg se mijenjaju g/kg
Timer debounce; //timer za debounce tipkala za odabir g/dag/kg
void konverzija(void);

int skalakonverzije=1;
float ocitanamasa;
float masa;

void mjerenje()//funkcija za ukljucivanje plave LED-ice koja označava da se neki predmet nalazi na vagi
{
    if(ocitanamasa>0.2 && ocitanamasa<=2000)
    {
        pnp=!pnp;
        }else{
            pnp=0;
            }
    }

void overload() //funkcija za ukljucivanje crvene LED-ice koja označava alarm
{
    if(ocitanamasa>2000)
    {
        on=0;
        alarm=!alarm;
        }else{
            alarm=0;
            on=1;
            }
    }
    
float preracun(float OM, int i) //funkcija za preracun mase
{
    float M;
    M=OM/i;
    return M;
    }

int main()
{  
    tipkakonverzije.mode(PullUp); // prekidni pin interno pritegnut na 3.3V
    tariranje.mode(PullUp);// ulaz interno pritegnut na 3.3V
    
    ocitanje.attach(&mjerenje,0.5);
    prekoracenje.attach(&overload,0.2);
    
    while(1) 
    {
        if (!tariranje) 
            scale.tare(); //funkcija za postavljanje vage u 0 pozvana pomoću tipkala tariranje iz HX711 libraryja  
    
        debounce.start(); //pocetak rada timera za debounce tipkala spojenog na prekidni pin
        tipkakonverzije.fall(&konverzija); //na padajuci brid se poziva funkcija koja postavlja varijablu skalakonverzije u 1 ili 1000
 
         
        ocitanamasa=scale.getGram(); // ocitavanje mase 
        
        while(ocitanamasa>2000)
        {
              ocitanamasa=scale.getGram();
              lcd.cls();
              lcd.locate(1,1);
              lcd.printf("Prekoracenje mase!"); //ispis upozoravajuce poruke na LCD-u u slucaju prekoracenja mase
              wait(0.2);
            }
        masa = preracun(ocitanamasa, skalakonverzije); // pretvorba g<->dag<->kg
        lcd.cls();
        lcd.locate(3,1);
        lcd.printf("Masa iznosi = ");
        
        if(skalakonverzije==1)
        {
            lcd.locate(4,2);
            lcd.printf("%.2f g", masa); //ispisivanje mase na LCD u gramima
            }
        if(skalakonverzije==10)
        {
            lcd.locate(5,2);
            lcd.printf("%.2f dag", masa); //ispisivanje mase na LCD u dekagramima
            }
        if(skalakonverzije==1000)
        {
            lcd.locate(6,2);
            lcd.printf("%.2f kg", masa); //ispisivanje mase na LCD u kilogramima
            }
    }

}

void konverzija() { 
if (debounce.read_ms()>200)
{
    if(skalakonverzije==1)
    {
        skalakonverzije=10;
    }
    else if(skalakonverzije==10)
    {
        skalakonverzije=1000;
    }else{
        skalakonverzije=1;
    } 
}
 debounce.reset();
}


