#include "mbed.h"
#include "buzzer.h"

InterruptIn button(USER_BUTTON);

Timer debounce;

Ticker flipper1;
Ticker flipper2;
Ticker flipper3;

Beep buzzer(D9);
AnalogIn IN0(A0);
AnalogIn IN1(A1);
AnalogIn IN2(A2);
AnalogIn IN3(A3);

DigitalOut OUT1(D3);
DigitalOut OUT2(D4);
DigitalOut OUT3(D5);

int k;

void flip1()   // flip 1 function
{
    OUT1 = !OUT1;
}
void flip2()   // flip 2 function
{
    OUT2 = !OUT2;
}
void flip3()   // flip 3 function
{
    OUT3 = !OUT3;
}


int main(){
while (1) {
        if (IN0>0.8) {
            OUT1=0;
            OUT2=0;
            OUT3=0;
        }
        if (IN0<0.8 & IN1>0.8 & IN2>0.8 & IN3>0.8) {
            OUT1=1;
            OUT2=1;
            OUT3=1;
        }
        if (IN0<0.8 & IN1>0.8) {     //Prekid na 1.liniji
            flipper1.attach(&flip1, 0.4);
        }
        if (IN0<0.8 & IN2>0.8) {     //Prekid na 2.liniji
            flipper2.attach(&flip2, 0.4);
        }
        if (IN0<0.8 & IN3>0.8) {     //Prekid na 3.liniji
            flipper3.attach(&flip3, 0.4);
        }
        if (IN3<0.8 ||IN2<0.8 || IN1<0.8) {
            k=1;
        } else {
            k=0;
        }
        if (IN0<0.8 & k==1) {     
            buzzer.beep(500,1);
        }
    }
}
