#include <string>
#include <vector>
#include <map>
#include "mbed.h"
#include "SRF05.h"
#include "configuration.h"
#include "configurationVerifier.h"
#include "monitoringExecutor.h"
#include "manualController.h"

using namespace std;

DigitalIn protectionOnOff(D3);
AnalogIn controlSensor(A0);
Timer controlSensorTimer;
PwmOut buzzer(D10);

DigitalIn autoModeOnOf(D6);
int controllMode = 0;

Ticker inputsControlTicker;

Serial* pc = new Serial(USBTX, USBRX);
SRF05* ranger = new SRF05(D8, D12);
PwmOut* rangerServo = new PwmOut(D5);
PwmOut* fan = new PwmOut(D11);
PwmOut* fanServo = new PwmOut(D9);
DigitalOut* greenLed = new DigitalOut(D4);
DigitalOut* redLed = new DigitalOut(D2);

void executeInputControll();
void controlSensorStateCheck();
bool checkIsAutoModeEnabled();

int main()
{   
    Configuration* config;
    vector<Configuration*> configsVec;
    
    protectionOnOff.mode(PullDown);
    autoModeOnOf.mode(PullDown); 
    inputsControlTicker.attach(&executeInputControll, 0.5);
    
    rangerServo->period_ms(20);
    fan->period_ms(20);
    fanServo->period_ms(20);
    
    MonitoringExecutor* executor;
    ManualController* manualController;
    
    char tmp;
    pc->printf("Welcome\n\r");
    pc->printf("For auto control choose 1, for manual control choose 2.\n\r");
    tmp = pc->getc();
    
    if(tmp == '1') {
        bool warningPrinted = false;
        while(!checkIsAutoModeEnabled()) {
            if(warningPrinted == false) {
                pc->printf("Auto mode should be enabled by switch 4.\n\r");
                warningPrinted = true;
                }
            wait(1);
            } 
        bool configCheck = false;
        pc->printf("Set configuration for auto controll:\n\r");
        config = new Configuration;
        while(configCheck == false) {
            pc->printf("For circle mode choose 0, for squere mode choose 1.\n\r");
            tmp = pc->getc();
            if(tmp == '0') {
                config->setMode(0);
            }
            else if(tmp == '1') {
                config->setMode(1);
            }
            else {
                config->setMode(2); 
            }
            configCheck = ConfigurationVerifier::verifyConfiguration(pc, config);
        }
        config->setDistance(15);
        config->setMonitoringDuration(180);
        config->setFanWorkingDuration(5);
        config->setFanYCoordinate(3);
        configsVec.push_back(config);
        executor = new MonitoringExecutor(configsVec[0], pc, ranger, rangerServo, fan, fanServo, greenLed, redLed);
        controllMode = 1;
        pc->printf("Manual controll started.\n\r");
        executor->startMonitoring();
    }
    else if(tmp == '2') {
        manualController = new ManualController(D7, pc, ranger, rangerServo, fan, fanServo, greenLed, redLed);
        controllMode = 2;
        pc->printf("Manual controll started.\n\r");
        manualController->executeManualControll();
        }
    else{
        pc->printf("Option %c is not supported. By!\n\r", tmp);
        }
    return 0;
}


void executeInputControll() {
    controlSensorStateCheck();
    if(checkIsAutoModeEnabled() == false && controllMode == 1) {
        pc->printf("Auto control mode is not enabled on switch 4. Monitoring execution stopped!\n\r");
        rangerServo->pulsewidth_us(0);
        fanServo->pulsewidth_us(0);
        fan->pulsewidth_us(0);
        wait(600);
    }
}

void controlSensorStateCheck(){
    if(protectionOnOff == 0) {
        buzzer = 0;
        return;
        }
    
    if(controlSensor >= 0.7) {
        if(controlSensorTimer.read() == 0){
            controlSensorTimer.start();
            buzzer = 0;
            }
        if(controlSensorTimer.read() >= 2){
            buzzer = 0.5;
        }
    }
    else{
        buzzer = 0;
        controlSensorTimer.reset();
        }    
}

bool checkIsAutoModeEnabled(){
    if(autoModeOnOf == 0) {
        return false;
    }
    return true;
}