#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/*
*This class is used to storing configuration parameters and carry them
*/
class Configuration
{
public:

    Configuration();
    
    ~Configuration();
 
    /**Returns working mode (0 - circle mode, 1 - square mode)*/
    int getMode();
    
    /**Setting working mode (0 - circle mode, 1 - square mode)*/
    void setMode(int mode);
    
    /**Returns the maximum distance at which objects are in the restricted area*/
    float getDistance();
    
    /**Setting the maximum distance at which objects are in the restricted area*/
    void setDistance(float distance);
    
    int getMonitoringDuration();
    void setMonitoringDuration(int monitoringDuration);
    int getFanWorkingDuration();
    void setFanWorkingDuration(int fanWorkingDuration);
    int getFanYCoordinate();
    void setFanYCoordinate(int fanYCoordinate);

private :
    int m_mode;
    float m_distance;
    int m_monitoringDuration; //in a seconds
    int m_fanWorkingDuration; //in a seconds
    int m_fanYCoordinate;
    
};
#endif