#include "mbed.h"
#include "TextLCD.h"
#include "HCSR04.h"

TextLCD lcd(PB_10, PA_8, PA_10, PB_3, PB_5, PB_4); //inicijacija 20x4 LCD-a
HCSR04 hcsr(PA_6, PA_7); //inicijalizacija senzora udaljenosti
DigitalOut Stop(PB_9); 
DigitalOut Kreni(PB_8);

InterruptIn Tipka(PA_5); 
Timer debounce; //deklaracija timera za debounce
void proces(void); //deklaracija funkcije

PwmOut SM(PB_0); //deklaracija izlaznog PWM pina

Ticker provjera; //deklaracija tickera 

Timer ZatRamp; //deklaracija timera za zadržavanje rampe

void mjerenje() //funkcija za detekciju predmeta ispred senzora udaljenosti
{
    hcsr.startMeasurement();
    if( hcsr.getDistance_mm()<90 && Kreni==1) //predmet ispred senzora udaljenosti
    {   
        SM=0.105;
        }
    if( hcsr.getDistance_mm()>90 && Kreni == 1) 
    {
        ZatRamp.start(); // timer za spuštanje rampe
        Stop=1;
        Kreni=0;
        lcd.cls();
        lcd.locate(4,1);
        lcd.printf("Dobro dosli!\n");
        lcd.locate(1,2);
        lcd.printf("Pritisnite tipku !");
        }
    }

int main()
{

    provjera.attach(&mjerenje,0.1); //tickeru se dodijeljuje funkcija mjerenje
    SM=0.0534; //pocetni otklon rampe
    Stop = 1; //aktivan crvena LEDica
    Kreni=0;
    Tipka.mode(PullUp); //digitalni ulaz za tipku pritegnut sa pull up otpornikom
    SM.period(0.020); //period PWM signala za motor
    lcd.cls();
    lcd.locate(4,1);
    lcd.printf("Dobro dosli!\n");
    lcd.locate(1,2);
    lcd.printf("Pritisnite tipku !");
    
    
    while(1)
    { 
        debounce.start(); //start tajmera za debounce tipke
        Tipka.fall(&proces); //na padajući brid tipke za podizanje rampe poziva se funkcija proces
        if(ZatRamp.read_ms()>5000) //provjera vrijednosti timera za spuštanje rampe
        {
            SM=0.0534;
            ZatRamp.reset();
        }
    }
}

void proces(){
   if (debounce.read_ms()>200)
   {
        hcsr.startMeasurement();
        if(hcsr.getDistance_mm()<90 && Kreni==0){
        lcd.cls();
        lcd.locate(4,1);
        lcd.printf("Dovidjenja!\n");
        lcd.locate(4,2);
        lcd.printf("Sretan put!");
       Stop=!Stop;
       Kreni=!Kreni;
       SM=0.105;
       }
    } 
    debounce.reset();
}