#include "mbed.h"
#include "led_Za_KRAJ.h"
//tipkala kao interupti
InterruptIn tipstart(p5,PullUp);
InterruptIn tipstop(p6,PullUp);
InterruptIn tiplijevo(p7,PullUp);
InterruptIn tipdesno(p8,PullUp);
//ledice izlazi
DigitalOut ledstart(p25);
DigitalOut ledstop(p26);
DigitalOut ledlijevo(p27);
DigitalOut leddesno(p28);
//potenciometar za brzinu
AnalogIn potbrzina(p15);
//PWM u lijevo
PwmOut PWMlijevo(p21);
//PWM u desno
PwmOut PWMdesno(p22);
//PWM buzzer
PwmOut buzzer(p23);

//definiranje statusa bulovi
volatile  bool vrti=false;
volatile  bool lijevo=false;
volatile  bool desno=true;

volatile float brzina=0;

//uključene funkcije
void Buzz(void); //za buzzer
void BuzzTIPKA(void); //za buzzer
void vrtiL(void); //pwm lijevi
void vrtiD(void); //pwm desni
void kreni(void); //za debouncanje
void stani(void); //za debouncanje
void LEFT(void); //za debouncanje
void RIGHT(void); //za debouncanje

//Ticker
Ticker tStart;

//Timer
Timer debounce;
Timer tKraj;

led_Za_KRAJ led(p29); //definirane pina ledice za kraj

int main()
{

//pokretanje debounc timera i interupata

    debounce.start();
    tipstart.fall(&kreni);
    tipstop.fall(&stani);
    tiplijevo.fall(&LEFT);
    tipdesno.fall(&RIGHT);

    tKraj.start();

//loop petlja

    while(1) {

//kreni stani vrti logika

        if(tKraj.read_ms()>10000) {
            

            led.ledblink();   //poziva klasu led_Za_KRAJ

        }



        if(vrti==true) {
            ledstop=0;
            ledstart=1;

            if(lijevo==true&desno==false) {
                ledlijevo=1;
                leddesno=0;

                vrtiL();

            } else if(lijevo==false&desno==true) {
                ledlijevo=0;
                leddesno=1;

                vrtiD();
            }

        } else if(vrti==false) {
            ledstop=1;
            ledstart=0;
            PWMdesno=0;
            PWMlijevo=0;

            if(lijevo==true&desno==false) {
                ledlijevo=1;
                leddesno=0;

            } else if(lijevo==false&desno==true) {
                ledlijevo=0;
                leddesno=1;
            }


        }
    }
}

//moje funkcije
void vrtiL()
{

    brzina=potbrzina;
    PWMlijevo.period(0.001);
    PWMlijevo=brzina;
    PWMdesno=0;
    wait(0.1);
}

void vrtiD()
{

    brzina=potbrzina;
    PWMdesno.period(0.001);
    PWMdesno=brzina;
    PWMlijevo=0;
    wait(0.1);
}

void Buzz()
{
    buzzer.period(0.002);
    buzzer=0.5;
    wait(0.2);
    buzzer=0;
}

void BuzzTIPKA()
{
    buzzer.period(0.001);
    buzzer=0.5;
    wait(0.2);
    buzzer=0;
}

//debouncanje funckije
void kreni()
{
    if(debounce.read_ms()>100) {
        vrti=true;
        BuzzTIPKA();
        tStart.attach(&Buzz, 2); //pokretanje buzera 1sec
        debounce.reset();
    }
}
void stani()
{
    if(debounce.read_ms()>100) {
        vrti=false;
        BuzzTIPKA();
        tStart.detach(); //zaustavljanje buzzera
        debounce.reset();
    }
}
void LEFT()
{
    if(debounce.read_ms()>100) {
        lijevo=true;
        desno=false;
        BuzzTIPKA();
        debounce.reset();
    }
}
void RIGHT()
{
    if(debounce.read_ms()>100) {
        lijevo=false;
        desno=true;
        BuzzTIPKA();
        debounce.reset();
    }
}