#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "keypad.h"
#include "TextLCD.h"
#include "Servo.h"
#include "rgb.h"

#define duljinaLozinke 4

RGBLed lediceRGB(PA_5, PA_6, PA_7);
Keypad tipkovnica(PB_4, PB_14, PB_5, PB_13, PA_8, PB_1, PB_10, PB_15);
TextLCD lcd(PC_10, PC_11, PC_12, PD_2, PC_3, PC_0);
Rtc_Ds1307 rtc(PB_9, PB_8);
Servo mojServo(PB_2);

Ticker blicanje;
Timer ledBlicanje;
Timer debounce;
InterruptIn tipkaloIzlaz(PB_3);
PwmOut piezoZvucnik(PC_7);

void pocetniPrikaz(void);
void postaviLozinku_pristup(void);
void led_flip(void);
void unosLozinkePristup(void);
void otkljucavanje(void);
void promjenaLozinkePristup(void);
void satDatum(void);

int lozinka_pristup[duljinaLozinke];
int unos_lozinkePristup[duljinaLozinke];
int lozinkaPromjena[duljinaLozinke];


int main() {
    Rtc_Ds1307::Time_rtc tm = {};
    tipkovnica.enablePullUp();
    mojServo.write(0.0);
    pocetniPrikaz();
    postaviLozinku_pristup();
    debounce.start();
    tipkaloIzlaz.rise(&otkljucavanje);
    
    while (1) {
        char utipkano = tipkovnica.getKey();
        switch (utipkano) {
            case 'A':
                promjenaLozinkePristup();
                break;
            case '#':
                unosLozinkePristup();
                break;
            default:
            {
                if (rtc.getTime(tm)) {
                    lcd.locate(3, 0);
                    lcd.printf("%02d.%02d.%04d.", tm.date, tm.mon, tm.year);
                    lcd.locate(4, 1);
                    lcd.printf("%02d:%02d:%02d", tm.hour, tm.min, tm.sec);
                }
            }
        }
    }
}


void pocetniPrikaz(void) {
    blicanje.attach(&led_flip, 0.5);
    lcd.cls();
    lcd.printf("DULJINA LOZINKE");
    lcd.locate(0, 1);
    lcd.printf("    %d ZNAKA    ", duljinaLozinke);
    wait(2.0);
    lcd.cls();
    lcd.printf("* POSTAVLJANJE *");
    lcd.locate(0, 1);
    lcd.printf("*   LOZINKE    *");
    wait(2.0);
    lcd.cls();
    blicanje.detach();
    lediceRGB.prikaz(0.0, 0.0, 0.0);
    
}

void led_flip(void) {
    lediceRGB.prikaz(0.0, 0.0, 1.0);
    ledBlicanje.start();
    if (ledBlicanje.read_ms() >= 500) {
        lediceRGB.prikaz(0.0, 0.0, 0.0);
        ledBlicanje.reset();
    }
}
    
void postaviLozinku_pristup(void) {
    blicanje.attach(&led_flip, 0.2);
    lcd.printf("POSTAVI LOZINKU");
    lcd.locate(0, 1);
    lcd.printf("   ZA PRISTUP   ");
    wait(1.5);
    lcd.cls();
    lcd.printf("POSTAVI LOZINKU");
    lcd.locate(6, 1);
    
    uint8_t i = 0;
    do {
        char utipkano = tipkovnica.getKey();
        if (utipkano != KEY_RELEASED && utipkano >= '0' && utipkano <= '9') {
            lozinka_pristup[i] = utipkano - 48;
            lcd.printf("*");
            wait(0.2);
            ++i;
        } else if ((utipkano != KEY_RELEASED) && (utipkano < '0' || utipkano > '9')) {
            blicanje.detach();
            lediceRGB.prikaz(1.0, 0.0, 0.0);
            lcd.cls();
            lcd.printf(" POGRESAN UNOS! ");
            piezoZvucnik.period(0.006);
            piezoZvucnik.write(0.1);
            wait(1.0);
            piezoZvucnik.write(0.0);
            lcd.cls();
            lediceRGB.prikaz(0.0, 0.0, 0.0);
            lcd.printf("POSTAVI LOZINKU");
            lcd.locate(6, 1);
            i = 0;
            blicanje.attach(&led_flip, 0.2);
        }
    } while (i < duljinaLozinke);
    
    lcd.cls();
    blicanje.detach();
    lcd.printf("    LOZINKA     ");
    lcd.locate(0, 1);
    lcd.printf(" JE POSTAVLJENA ");
    piezoZvucnik.period(0.001);
    piezoZvucnik.write(0.5);
    lediceRGB.prikaz(0.0, 1.0, 0.0);
    wait(2.0);
    blicanje.detach();
    lediceRGB.prikaz(0.0, 0.0, 0.0);
    piezoZvucnik.write(0.0);
    lcd.cls();
}

void unosLozinkePristup(void) {
    lcd.cls();
    lcd.printf("UNESITE LOZINKU");
    blicanje.attach(&led_flip, 0.2);
    lcd.cls();
    lcd.printf("  UNOS LOZINKE  ");
    lcd.locate(6, 1);
    
    uint8_t i = 0;
    do {
        char utipkano = tipkovnica.getKey();
        if (utipkano != KEY_RELEASED && utipkano >= '0' && utipkano <= '9') {
            unos_lozinkePristup[i] = utipkano - 48;
            lcd.printf("*");
            wait(0.2);
            ++i;
        }
    } while (i < duljinaLozinke);
    blicanje.detach();
    
    uint8_t brojac = 0;
    for (uint8_t i = 0; i < duljinaLozinke; ++i) {
        if (unos_lozinkePristup[i] == lozinka_pristup[i]) 
            brojac++;
    }
            
    if (brojac == duljinaLozinke) {
        lediceRGB.prikaz(0.0, 1.0, 0.0);
        lcd.cls();
        lcd.printf("    PRISTUP    ");
        lcd.locate(4, 1);
        lcd.printf("OMOGUCEN");
        piezoZvucnik.period(0.001);
        piezoZvucnik.write(0.5);
        wait(2.0);
        lcd.cls();
        otkljucavanje();
    } else if (brojac != duljinaLozinke) {
        lediceRGB.prikaz(1.0, 0.0, 0.0);
        lcd.cls();
        lcd.printf("    PRISTUP    ");
        lcd.locate(3, 1);
        lcd.printf("ONEMOGUCEN");
        piezoZvucnik.period(0.004);
        piezoZvucnik.write(0.1);
        wait(2.0);
        lediceRGB.prikaz(0.0, 0.0, 0.0);
        piezoZvucnik.write(0.0);
        lcd.cls();
    }
}

void promjenaLozinkePristup(void) {
    lcd.cls();
    blicanje.attach(&led_flip, 0.2);
    lcd.printf("PROMJENA LOZINKE");
    lcd.locate(0, 1);
    lcd.printf("   ZA PRISTUP   ");
    lcd.cls();
    lcd.printf("TRENUTNA LOZINKA");
    lcd.locate(6, 1);
    
    uint8_t i = 0;
    do {
        char utipkano = tipkovnica.getKey();
        if (utipkano != KEY_RELEASED && utipkano >= '0' && utipkano <= '9') {
            lozinkaPromjena[i] = utipkano - 48;
            lcd.printf("*");
            wait(0.2);
            ++i;
        }
    } while (i < duljinaLozinke);
    blicanje.detach();
    
    uint8_t brojac = 0;
    for (uint8_t i = 0; i < duljinaLozinke; ++i) {
        if (lozinkaPromjena[i] == lozinka_pristup[i])
            brojac++;
    }
    
    if (brojac == duljinaLozinke) {
        lediceRGB.prikaz(0.0, 1.0, 0.0);
        wait(1.0);
        lediceRGB.prikaz(0.0, 1.0, 0.0);
        blicanje.attach(&led_flip, 0.2);
        lcd.cls();
        lcd.printf(" NOVA LOZINKA");
        lcd.locate(6, 1);
        
        uint8_t i = 0;
        do {
            char utipkano = tipkovnica.getKey();
            if (utipkano != KEY_RELEASED && utipkano >= '0' && utipkano <= '9') {
                lozinka_pristup[i] = utipkano - 48;
                lcd.printf("*");
                wait(0.2);
                ++i;
            }
        } while (i < duljinaLozinke);
        blicanje.detach();
        
        lcd.cls();
        lcd.locate(4, 0);
        lcd.printf("LOZINKA");
        lcd.locate(0, 1);
        lcd.printf("JE PROMIJENJENA!");
        piezoZvucnik.period(0.001);
        piezoZvucnik.write(0.5);
        lediceRGB.prikaz(0.0, 1.0, 0.0);
        wait(2.0);
        piezoZvucnik.write(0.0);
        lediceRGB.prikaz(0.0, 0.0, 0.0);
        lcd.cls();
    } else if (brojac != duljinaLozinke) {
        lediceRGB.prikaz(1.0, 0.0, 0.0);
        lcd.cls();
        lcd.printf("KRIVA LOZINKA...");
        lcd.locate(0, 1);
        lcd.printf("UNESITE PONOVNO!");
        wait(1.0);
        lediceRGB.prikaz(0.0, 0.0, 0.0);
        lcd.cls();
    }
}

void otkljucavanje(void) {
    if (debounce.read_ms() > 200) {
    piezoZvucnik.period(0.001);
    piezoZvucnik.write(0.2);
    wait(0.5);
    lcd.cls();
    lediceRGB.prikaz(0.0, 1.0, 0.0);
    lcd.printf(" OTKLJUCAVANJE! ");
    lcd.locate(0, 1);
    lcd.printf("****************");
    mojServo.write(90.0);
    wait(1.5);
    lcd.cls();
    lcd.printf("****************");
    lcd.locate(0, 1);
    lcd.printf("   OTKLJUCANO   ");
    piezoZvucnik.write(0.0);
    
    wait(10.0);
    
    lcd.cls();
    piezoZvucnik.period(0.001);
    piezoZvucnik.write(0.5);
    lediceRGB.prikaz(1.0, 0.0, 0.0);
    lcd.printf(" ZAKLJUCAVANJE! ");
    lcd.locate(0, 1);
    lcd.printf("****************");
    mojServo.write(0.0);
    wait(1.5);
    lcd.cls();
    lcd.printf("****************");
    lcd.locate(0, 1);
    lcd.printf("   ZAKLJUCANO   ");
    wait(1.5);
    lediceRGB.prikaz(0.0, 0.0, 0.0);
    piezoZvucnik.write(0.0);
    lcd.cls();
    debounce.reset();
    lcd.cls();
    }
}