#include "mbed.h"
#include "TextLCD.h"    //ovo je head za LCD
#include "ULN2003.h"    //ovo je head za motor

Serial pc(USBTX, USBRX); // tx, rx
ULN2003 postavljac(PB_10, PB_4, PB_5, PB_3, 4096); //definiranje izlaza za stepper

I2C i2c_lcd(I2C_SDA, I2C_SCL); // SDA, SCL, I2C komunikacija za LCD
TextLCD_I2C lcd(&i2c_lcd, 0x4e, TextLCD::LCD16x2);  // I2C bus, PCF8574 Slaveaddress, LCD Type; LCD na I2C komunikaciji:

//TextLCD lcd(PA_0, PA_1, PA_4, PB_0, PC_1, PC_0); // RS, E, D4-D7, LCDType=LCD16x2, BL=NC, E2=NC, LCDTCtrl=HD44780; spajanje lcd-a na pinove (ako zatreba)

//SPI spi_lcd(P_, P_NC, P_); // MOSI, MISO, SCLK; // SPI komunikacija (ako zatreba):
 
DigitalOut led1(PC_10); //LED c.s. 1-4
DigitalOut led2(PC_12); 
DigitalOut led3(PA_6);
DigitalOut led4(PA_7);
DigitalOut ledi(PC_2);  //LED stanja isključenja 
DigitalOut ledu(PC_3);  //LED stanja uključeno
DigitalOut ledk(PA_1);  //LED kvara
DigitalOut leds(PA_0);  //LED kvara
DigitalIn gp(PB_1);  //LED k
                            
                            //Analogni ulazi za mjerenje struje:
AnalogIn strujaCS1(PC_0);
AnalogIn strujaCS2(PC_1);
AnalogIn strujaCS3(PB_0);
AnalogIn strujaCS4(PA_4);
                               //Interrupt pinovi:
InterruptIn k_uklj1(PA_13);     //uklj. kontakt 1
InterruptIn k_uklj2(PA_14);     //uklj. kontakt 2
InterruptIn k_isklj(PA_15);     //isklj. kontakt
InterruptIn kv_isklj(PD_2);     //isključenje kvara (tipka)
InterruptIn lom(PA_8);

PwmOut zvono1(PC_6);              //pinovi za zvona
PwmOut zvono2(PC_8);
PwmOut alarm(PA_9);            

                        //Timeri:
Timer osnovno;          //za vraćanje u osnovno nakon isključenja
Ticker tcs;             //ticker za blink signala
Timeout Tukljucenje;    //time out za trajanje uključenja
Timer debounce;         //timer za debounce     
Ticker mjere;           //ticker za mjerenje struje LED
Timer osovine;           //timer za blokadu osnovnog stanja za više osovina
Ticker ispis_LCD;
                    //Varijable:
bool uklj1=0;       //uključenje po kontaktu 1
bool uklj2=0;       //uključenje po kontaktu 2
bool isklj=0;       //isključenje po isključnom kontaktu
bool kvar=0;        //kvar: stanje ima-nema
bool smetnja=0;     //smetnja: stanje ima-nema
int bkvar=0;        //brojač kvarova
int bsmetnja=0;     //brojač smetnji
bool upis_k=0;      //pomoćna varijabla za upis kvara na LCD samo kad se poajvi kvar)
bool upis_s=0;      //pomoćna varijabla za upis smetnje na LCD samo kad se poajvi)
char s_aktiv;       //varijabla za ispis aktivnog kvara na LCD
char k_aktiv;       //varijabla za ispis aktivnog kvara na LCD
bool deaktiv_lcd=0; //varijabla za ispis na LCD nakon poništenja kvara/smetnje
bool p_gore=0;      //pomoćna varijabla za dizanje postavljača kod isključenja
float struja1;      //varijable vrijednosti analognog ulaza za kontrolu LED CS
float struja2;
float struja3;
float struja4;
bool U=0;           //pomoćna varijabla za uključenje
bool aisk=0;        //pomoćna varijabla za automatsko isključenje (vremensko)
bool kvar_l=0;
bool alarm_i=0;

void ukljucenje1();         //funkcija (potprogram) uključenja sa strane 1
void ukljucenje2();         //funkcija (potprogram) za uključenje sa strane 2
void iskljucenje();         //funkcija (potpogram) za isključenje
void kvar_lcd(void);        //funkcija za ispis na lcd
void kvar_isklj(void);      //funkcija za kvar kod aktivacije isklj. kontakta
void postav_gore(void);     //funkcija za dizanje motke
void postav_dolje(void);    //funkcija za spuštanje motke
void cs(void);              //funkcija za cestovni signal
void upis_kvara();          //funkcija ispisa na LCD
void zvona();               //funkcija za buzzer
void pr_zv();               //gašenje zvona
void mjerenja();            //funkcija za  struje LED 
void T_iskljucenje();       //funkcija za automatsko isključenje (vremensko)
void osnovno_st();
void lom_m();
void lom_m_k();
void alarm_u();

 
int main() {
     lcd.setBacklight(TextLCD::LightOn);    //uključenje pozadinskog svjetla na LCD
         
     k_uklj1.mode(PullDown);    //konfiguracija tastera na PullDown
     k_uklj2.mode(PullDown);
     k_isklj.mode(PullDown);
     kv_isklj.mode(PullDown);
    
     led1=0; led2=0;
    
    lcd.setCursor(TextLCD::CurOn_BlkOn); // Uključenje i blinkanje kursora na LCD 
 
    //debounce.start();
                                    //konfiguracija interrupt kontakata na uzlazni/silazni brid
       k_uklj1.rise(&ukljucenje1);
       k_uklj2.rise(&ukljucenje2);
       k_isklj.fall(&iskljucenje);
       kv_isklj.fall(&kvar_isklj);
       lom.fall(&lom_m);
       lom.rise(&lom_m_k);
   
        lcd.cls();   //čišćenje displeja
        lcd.printf("Kvar %i\nSmetnja %i", bkvar, bsmetnja); //prikaz broja kvara i smetnje na lcd 
         
         if(gp==0){
               postav_gore();
               wait(8);
               }
               
               //glavna petlja
   while(1) {
                            //uvjeti za LED uključenja, isključenja i kvara
       if(uklj1==1 || uklj2==1) {
       ledu=1;
       }
        else {
            ledu=0;
            }
        if(isklj==1) {
            ledi=1;
            }
        else {
            ledi=0;
            }
        if(kvar==1) {
            ledk=1;}
            else {
                    ledk=0;
                    alarm_i=0;}
        if(smetnja==1) {
            leds=1;}
            else {
                    leds=0;}
                    
                               
                                //uključenje:
                                
       if((uklj1==1 || uklj2==1) && isklj==0){
                        
            
            //mjerenja();
            if(U==0){
                
                zvona();
                led3=1;
                led1=1;
            tcs.attach(&cs, 0.5); 
             //mjere.attach(&mjerenja, 1.5); 
             //start tickera za CS, treptanje dioda
            Tukljucenje.attach(&T_iskljucenje, 40.0);
            wait(8); //predzvonjenje
            postav_dolje();
             pr_zv(); 
             U=1;
            }
          }
                        //Automatsko isključenje ako je proteklo vrijeme
          if(aisk==1) {
               
            smetnja=1;
            leds=1;
            bsmetnja=bsmetnja+1;
            postav_gore();  
            wait(0.2);        
            Tukljucenje.detach();
            //mjere.detach();
            tcs.detach();           //isključenje signala
            led1=0; 
            led2=0; 
            led3=0;
            led4=0; 
            uklj1=0;
            uklj2=0;
            U=0;
            aisk=0;
            alarm_u();
            if(gp==0){
                kvar=1;
                }
        }
                        //Isključenje na isključnom kontaktu
                        
       if((uklj1==1 || uklj2==1) && (isklj==1)) {   //isključenje za stranu 1
                
                wait(2);
                if(p_gore==0) {
                postav_gore();
                wait(0.1);
                p_gore=1;
                if(gp==0){
                   kvar=1;
                   }
                   }
                Tukljucenje.detach();
                 tcs.detach();         //isključenje signala
                   led1=0; 
                   led2=0;
                   led3=0;
                   led4=0;  
                    
                  osnovno.start();  //pokretanje timera osnovno
                }
                         //Dovođenje u osnovno stanje               
                
           if(osnovno.read()>=40 || (uklj2==1 && uklj1==1)) {
            if(osnovno.read()>=40) {
                smetnja=1;
                leds=1;
                bsmetnja=bsmetnja+1;
                osnovno_st();
                alarm_u();
                }
                else {
                    osovine.start();
                    if(osovine.read()>=2) {
                    osnovno_st(); 
                    }
                 }
                }
             
             wait(0.1);   
                            //Uključenje kvara kod aktivacije isklj. kontakta bez uključenja:
                              
        if(((uklj1==0 && uklj2==0) && (isklj==1)) || lom==0){      //kvar kod isključnog kontakta bez uključenja
              kvar=1;
              alarm_u();
              
              }
              
        kvar_lcd();
                  } //kraj while(1)
            }    //kraj int main()
   
   
     void ukljucenje1(void){
     uklj1=1; 
     osovine.reset();
     if(uklj2==0) {
     isklj=0;
     } 
     ledu=1;
         }
                      
    void ukljucenje2(void){
     uklj2=1; 
     osovine.reset();
     if(uklj1==0) {
     isklj=0; 
     }
     ledu=1;
     }
                      
    void iskljucenje(void){
       isklj=1;               
       ledi=1;
       }
                 
    void kvar_lcd(void) {
                if(kvar==1){
                k_aktiv=65;
                }
                else {
                    k_aktiv=73;
                    }          
            if(kvar==1 && upis_k==0) {
                bkvar=bkvar+1;
            lcd.cls();
            lcd.printf("Kvar %i %c\nSmetnja %i %c", bkvar, k_aktiv, bsmetnja, s_aktiv);
            upis_k=1;
            } 
            else if(kvar==0) {
            upis_k=0;
            }       
            
            if(smetnja==1){
                s_aktiv=65;
                }
                else {
                    s_aktiv=73;
                    }                         
            if(smetnja==1 && upis_s==0) {       //ispis smetnje
            //bsmetnja=bsmetnja+1;
            lcd.cls();
            lcd.printf("Kvar %i %c\nSmetnja %i %c", bkvar, k_aktiv, bsmetnja, s_aktiv);
            upis_s=1;
            } 
            else if(smetnja==0) {
                upis_s=0;
                }  
            if (deaktiv_lcd==1) {
            lcd.cls();
            lcd.printf("Kvar %i %c\nSmetnja %i %c", bkvar, k_aktiv, bsmetnja, s_aktiv);
            deaktiv_lcd=0;
            }
           }
           
                       
  void kvar_isklj(void) {
        
        if(uklj1==0 && uklj2==0) {
        if(kvar_l==0) {
            kvar=0;
            }
        smetnja=0;
        wait(0.2);
        deaktiv_lcd=1;
        //alarm=0;
        alarm_u();
        }
           }
 
 void postav_dolje() {
     postavljac.moveForward(100,20);
     pr_zv();
               }
     
 void postav_gore() {
     postavljac.moveReverse(100,15);
     }
     
void cs(void) {
    led1=!led1;
    led2=!led2;
    led3=!led3;
    led4=!led4;
    mjerenja();
       }
    
void zvona() {
zvono1.period(1); // set PWM period to 10 ms
zvono1=0.5;      // set duty cycle to 80%
zvono2.period(1); // set PWM period to 10 ms
zvono2=0.5;      // set duty cycle to 80%
}

void pr_zv() {
    zvono1=0;
    zvono2=0;
    }

void mjerenja() {

if(led1==1) {
    struja1=strujaCS1;
    struja3=strujaCS3;
   if(struja1<=0.2f || struja1>=0.55f || struja3<=0.2f || struja3>=0.55f) {
    kvar=1;
    ledk=1;
    alarm_u();
      }
       }
       
    if(led2==1) {
    struja2=strujaCS2;
    struja4=strujaCS4;
        if(struja2<=0.2f || struja2>=0.55f || struja4<=0.2f || struja4>=0.55f) {
    kvar=1;
    ledk=1;
    alarm_i=1;
    alarm_u();
     }
       }
       if(uklj1==0 && uklj2==0){
           mjere.detach();}
}

void T_iskljucenje() {
    aisk=1;
       }      
       
void osnovno_st() {
        
            uklj1=0;
            uklj2=0;
            isklj=0;
            wait(0.05);
            U=0;
            osnovno.stop();
            osnovno.reset();
            p_gore=0;
            osovine.stop();
                 }   
                 
void lom_m() {
    kvar=1;
    kvar_l=1;
    alarm_u();
    }   
    
void lom_m_k() {
    kvar_l=0;
    }
    
void alarm_u() {
        
        if(kvar==1 && alarm_i==0) {
            alarm.period(2); // set PWM period to 10 ms
            alarm=0.9;
            wait(0.1);
             }
                
            else {
                alarm=0;}
            
            }
        

            