#include "mbed.h"
#include "pitanja.h"
#include "TextLCD.h"

DigitalOut myled(LED1);
TextLCD lcd(PA_0,PA_1,PA_4,PB_0,PC_1,PC_0); // Rs, E, D4-D7
InterruptIn button(USER_BUTTON);
DigitalIn buttonC(PA_9);
DigitalIn buttonB(PC_7);
DigitalIn buttonA(PB_6);
Timer timer;
int i = 1;
int brojTocnih = 0;

void start();
void zapocniKviz();
void postaviPitanje(string pitanjeA,string pitanjeB, string odgA, string odgB, string odgC, string tocanOdg);

int main()
{
    std::vector<Pitanje> pitanja = Pitanje::init();
    myled = 0;
    string pitanjeA;
    string pitanjeB;
    string odgA;
    string odgB;
    string odgC;
    string tocanOdg;

    zapocniKviz();
    int j = 1;
    while(j) {
        Pitanje* iter = pitanja.begin();
        int i = 1;
        for ( ; iter !=  pitanja.end(); iter++) {
            pitanjeA = (*iter).getPitanjeA();
            pitanjeB = (*iter).getPitanjeB();
            odgA = (*iter).getOdgA();
            odgB = (*iter).getOdgB();
            odgC = (*iter).getOdgC();
            lcd.cls();
            tocanOdg = (*iter).getTocanOdg();
            lcd.printf("%d. pitanje:",i);
            wait(1.5);
            lcd.cls();
            i++;

            postaviPitanje(pitanjeA, pitanjeB, odgA, odgB, odgC, tocanOdg);

            if(i == 10) {
                j = 0;
            }
        }
    }
    lcd.cls();
    lcd.printf("Kviz zavrsen!");
    lcd.locate(3,1);
    lcd.printf("Tocno %d/10", brojTocnih);
    wait(3);
}

void start()
{
    i = 0;
}

void zapocniKviz()
{
    lcd.locate(2,0);
    lcd.printf("Zapocni kviz");
    lcd.locate(5,1);
    lcd.printf("Sretno!");
    while(i) {
        button.rise(&start);
    }
    lcd.cls();
}

void postaviPitanje(string pitanjeA,string pitanjeB, string odgA, string odgB, string odgC, string tocanOdg)
{
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%s",pitanjeA.c_str());
    lcd.locate(0,1);
    lcd.printf("%s",pitanjeB.c_str());
    wait(3);
    lcd.cls();

    lcd.printf("A)%s",odgA.c_str());
    wait(2);
    lcd.cls();

    lcd.printf("B)%s",odgB.c_str());
    wait(2);
    lcd.cls();

    lcd.printf("C)%s",odgC.c_str());
    wait(2);
    lcd.cls();

    timer.reset();
    timer.start();
    lcd.printf("Vas odgovor je?");
    while(timer.read_ms() < 3500) {
        if(buttonA || buttonB || buttonC) {
            if (buttonA &&(tocanOdg == odgA)) {
                lcd.cls();
                lcd.locate(5,0);
                lcd.printf("Tocno");
                wait(1);
                brojTocnih++;
                break;
            }
            if (buttonB &&(tocanOdg == odgB)) {
                lcd.cls();
                lcd.locate(5,0);
                lcd.printf("Tocno");
                wait(1);
                brojTocnih++;
                break;
            }
            if (buttonC &&(tocanOdg == odgC)) {
                lcd.cls();
                lcd.locate(5,0);
                lcd.printf("Tocno");
                wait(1);
                brojTocnih++;
                break;
            } else {
                lcd.cls();
                lcd.locate(5,0);
                lcd.printf("Krivo");
                wait(1);
                break;
            }
        }
        if (timer.read_ms() >2500) {
            lcd.cls();
            lcd.printf("Isteklo vrijeme");
            wait(1);
            break;
        }
    }
}