#include "mbed.h"
#include "Akvizicija.h" // simulacija vrijednosti temperature i vlage - očitavanje vrijednosti s potenciometra

#define debug true //flag za debug

Akvizicija pot(p19,p20);  //stvaranje objekta pot, p19 - pin potenciometra koji simulira temperaturu, p20 - pin potenciometra koji simulira vlagu

Serial nextion(p13, p14);  // tx, rx pinovi za Nextion zaslon
Serial pc(USBTX, USBRX, 115200); //PC monitor
LocalFileSystem local("local");               // Stvaranje objekta localfilesystem-a pod nazivom "local"

Ticker akvizicija; //ticker za dohvaćanje vrijednosti temperature i vlage
Ticker NextionIspis; //ticker za slanje podataka s lpc-a na zaslon
 
PwmOut vent(p21); //stvaranje pwm objekta pod nazivom "vent"

char buffer[40]; //veličina buffera za primanje znakova sa nextion zaslona (dovoljno je 40 znakova)
int znak = 0; // redni broj znaka u polju znakova (stringu)
char read_string[128]; // veličina buffera za čitanje podataka iz datoteke (dovoljno je 128 znakova)

//globalne varijable za spremanje trenutnih vrijednosti
//postavljene su u 0 ali se prilikom pokretanja vrijednosti pročitaju iz datoteke i spreme u globalne varijable 
float PGZ = 0;
float IGZ = 0;
float DGZ = 0;
int hister = 0;
int pwm_fan = 0;
char ssid[30] = "";
char pass[30] = "";
float tset = 0;
int hset = 0;

//varijavble za spremanje trenutnih vrijednosti temperature i vlage
float temperature = 0;
float humidity = 0;

int broj_stranice = 0; //podatak o tome koja je stranica trenutno aktivna na Nextion zaslonu

//funkcija koja je dodijeljena tickeru1
void dohvativr()
{
    if (broj_stranice ==0) {
        temperature = pot.getTemp();
        humidity = pot.getVlaga();
    }
}

//funkcija koja je dodijeljena tickeru2
void nextion_ispis()
{
    if (broj_stranice == 0) {//ispisuj samo ako je aktivna stranica broj 0

        nextion.printf("add 10,0,");
        nextion.printf("%d",(int)temperature);
        nextion.printf("\xFF\xFF\xFF");

        nextion.printf("add 10,1,");
        nextion.printf("%d",(int)tset);
        nextion.printf("\xFF\xFF\xFF");

        nextion.printf("add 11,0,");
        nextion.printf("%d", (int)humidity);
        nextion.printf("\xFF\xFF\xFF");

        nextion.printf("add 11,1,");
        nextion.printf("%d",(int)hset);
        nextion.printf("\xFF\xFF\xFF");

        nextion.printf("temp.txt=\"");
        nextion.printf("%.1f\260C",temperature); // znak 260 je "°"
        nextion.printf("\"\xFF\xFF\xFF");

        nextion.printf("vlaga.txt=\"");
        nextion.printf("%.0f%c", humidity, 37); //znak 37 je "%"
        nextion.printf("\"\xFF\xFF\xFF");
    }
}

//funkcija koja vraća substring nekog stringa, argumenti su string, početak (m-ti znak) i kraj (n-ti znak)
char* substr(const char *src, int m, int n)
{
    // veličina substringa
    int len = n - m;

    // allocate (len + 1) chars for destination (+1 for extra null character)
    // The C library function void *malloc(size_t size) allocates the requested memory and returns a pointer to it.
    char *dest = (char*)malloc(sizeof(char) * (len + 1));

    // extracts characters between m'th and n'th index from source string and copy them into the destination string
    for (int i = m; i < n && (*src != '\0'); i++) {
        *dest = *(src + i);
        dest++;
    }

    // null-terminate the destination string
    *dest = '\0';

    // return the destination string
    return dest - len;
}

//Rx_interrupt rutina
void Rx_Interrupt(void)
{
    char c;
    bool zapis;

    if(nextion.readable()) {
        c = nextion.getc(); //očitaj znak i pohrani ga u varijablu "c"
        buffer[znak] = c; //pohrani znak "c" u polje znakova pod indexom "znak"
        znak++; //inkrement indexa
        if ((znak >= 3) && (buffer[znak-1] == 0xff) && (buffer[znak-2] == 0xff) && (buffer[znak-3] == 0xff)) {  //ako primljena poruka završava s “\xFF\xFF\xFF” (kraj naredbe)

            if (debug) pc.printf("primljeno: %s\n\r", buffer); // prikaži primljenu poruku
            //strstr funkcija vraća index na kojem se prvi puta pojavljuje substring u stringu, ako ne postoji vraća NULL
            if(strstr(buffer, "ppage") != NULL) { //ako je primljen broj stranice
                broj_stranice = buffer[5] - 48; //npr. ppage2 >> buffer[5]-48 = 50 - 48 = 2
                if (debug) pc.printf("stranica %d\n\r", broj_stranice); // prikaži primljenu poruku
            }

            else if(strstr(buffer, "pPGZ=") != NULL) {
                char* dest = substr(buffer, strlen("pPGZ="), znak-3); //pokazivac na vrijednost PGZ-a u bufferu
                PGZ = atof(dest);
                if (debug) pc.printf("PGZ: %.3f\n\r", PGZ); // prikaži primljenu poruku
                zapis = true;
            } else if(strstr(buffer, "pIGZ=") != NULL) {
                char* dest = substr(buffer, strlen("pIGZ="), znak-3); //pokazivac na vrijednost IGZ-a u bufferu
                IGZ = atof(dest);
                if (debug) pc.printf("IGZ: %.3f\n\r", IGZ); // prikaži primljenu poruku
                zapis = true;
            } else if(strstr(buffer, "pDGZ=") != NULL) {
                char* dest = substr(buffer, strlen("pDGZ="), znak-3); //pokazivac na vrijednost DGZ-a u bufferu
                DGZ = atof(dest);
                if (debug) pc.printf("DGZ: %.3f\n\r", DGZ); // prikaži primljenu poruku
                zapis = true;
            } else if(strstr(buffer, "phister=") != NULL) {
                char* dest = substr(buffer, strlen("phister="), znak-3);
                hister = atoi(dest);
                if (debug) pc.printf("histereza: %d\n\r", hister); // prikaži primljenu poruku
                zapis = true;
            } else if(strstr(buffer, "ppwm_fan=") != NULL) {
                char* dest = substr(buffer, strlen("ppwm_fan="), znak-3);
                pwm_fan = atoi(dest);
                if (debug) pc.printf("pwm fan: %d\n\r", pwm_fan); // prikaži primljenu poruku
                vent = pwm_fan/100.0; // postavi vrijednost faktora vođenja
                zapis = true;
            } else if(strstr(buffer, "ps=") != NULL) {
                char* dest = substr(buffer, strlen("ps="), znak-3);
                strcpy(ssid, dest);
                if (debug) pc.printf("ssid: %s\n\r", ssid); // prikaži primljenu poruku
                zapis = true;
            } else if(strstr(buffer, "pp=") != NULL) {
                char* dest = substr(buffer, strlen("pp="), znak-3);
                strcpy(pass, dest);
                if (debug) pc.printf("pass: %s\n\r", pass); // prikaži primljenu poruku
                zapis = true;
            } else if(strstr(buffer, "ptset=") != NULL) {
                char* dest = substr(buffer, strlen("ptset="), znak-3);
                tset = atof(dest);
                if (debug) pc.printf("temp set: %.1f\n\r", tset); // prikaži primljenu poruku
                zapis = true;
            } else if(strstr(buffer, "phset=") != NULL) {
                char* dest = substr(buffer, strlen("phset="), znak-3);
                hset = atoi(dest);
                if (debug) pc.printf("histereza: %d\n\r", hset); // prikaži primljenu poruku
                zapis = true;
            }
            if(zapis) { //ako je došlo do promjene parametara otvori datoteku i pohrani vrijednosti
                FILE *File2 = fopen("/local/textfile.txt", "w");  // Open "out.txt" on the local file system for writing
                fprintf(File2, "%.3f\r%.3f\r%.3f\r%d\r%d\r%s\r%s\r%.1f\r%d\r", PGZ, IGZ, DGZ, hister, pwm_fan, ssid, pass, tset, hset);
                fclose(File2);
                zapis = false;
            }

            memset(buffer,0,strlen(buffer)); //isprazni buffer
            znak = 0; //ponovno sastavljaj polje znakova od nulte pozicije
        }
    }
}

void init(){

nextion.baud(115200);
    nextion.attach(&Rx_Interrupt, Serial::RxIrq); // Serial prekid
    akvizicija.attach(&dohvativr, 0.5); //ticker, svakih 500ms
    NextionIspis.attach(&nextion_ispis, 0.5); //ticker, svakih 500ms

//-------------------------- citanje iz datoteke --------------------------------------------//

    FILE* File2 = fopen ("/local/textfile.txt","r"); // otvori datoteku
    fgets(read_string,128,File2); // pročitaj podatke
    fclose(File2); // zatvori datoteku

    int init_size = strlen(read_string);
    char delim[] = "\n\r";

    char *ptr = strtok(read_string, delim);

    int i = 0;

    while(ptr != NULL) {

        switch (i) {

            case 0:
                PGZ = atof(ptr);
                break;

            case 1:
                IGZ = atof(ptr);
                break;

            case 2:
                DGZ = atof(ptr);
                break;

            case 3:
                hister = atoi(ptr);
                break;

            case 4:
                pwm_fan = atoi(ptr);
                break;

            case 5:
                strcpy(ssid, ptr);
                break;

            case 6:
                strcpy(pass, ptr);
                break;

            case 7:
                tset = atof(ptr);
                break;

            case 8:
                hset = atoi(ptr);
                break;

            default:
                printf("Greska\n\r");
        }

        if (debug) printf("%s", ptr);
        ptr = strtok(NULL, delim);
        i++;

    }
    i = 0; //jel treba uopće ovo?
//---------------------------------------------------------------------------------------------------//

//-------------------------- slanje zaslonu prilikom inicijalizacije --------------------------------------------//

    nextion.printf("page2.t0.txt=\"");
    nextion.printf("%.3f",PGZ);
    nextion.printf("\"\xFF\xFF\xFF");

    nextion.printf("page2.t1.txt=\"");
    nextion.printf("%.3f",IGZ);
    nextion.printf("\"\xFF\xFF\xFF");

    nextion.printf("page2.t2.txt=\"");
    nextion.printf("%.3f",DGZ);
    nextion.printf("\"\xFF\xFF\xFF");

    nextion.printf("page2.n0.val=");
    nextion.printf("%d",hister);
    nextion.printf("\xFF\xFF\xFF");

    nextion.printf("page2.n1.val=");
    nextion.printf("%d", pwm_fan);
    nextion.printf("\xFF\xFF\xFF");

    nextion.printf("page4.t0.txt=\"");
    nextion.printf("%s",ssid);
    nextion.printf("\"\xFF\xFF\xFF");

    nextion.printf("page4.t1.txt=\"");
    nextion.printf("%s",pass);
    nextion.printf("\"\xFF\xFF\xFF");

    nextion.printf("page0.t6.txt=\"");
    nextion.printf("%.1f",tset);
    nextion.printf("\"\xFF\xFF\xFF");

    nextion.printf("page0.t2.txt=\"");
    nextion.printf("%d",hset);
    nextion.printf("\"\xFF\xFF\xFF");

//---------------------------------------------------------------------------------------------------//

}

void pwmInit(){
    vent.period(0.010); //pwm frekvencija 100 Hz
    vent = pwm_fan/100.0; //skaliraj pwm
}

int main()
{
    init();
    pwmInit();
    
    while (1) {
        wait(0.5); // Ne radi ništa
    }
}


