//Izvorne datoteke
#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "DetectOff.h"

//Inicijalizacija varijabli
Serial pc(USBTX,USBRX);
Timer debounce;
Rtc_Ds1307 rtc(p9,p10);
InterruptIn detector(p13);
DigitalOut ledica(p15);
DigitalIn taster(p18);
DetectOff led(LED2);
Rtc_Ds1307::Time_rtc tmt = {};
LocalFileSystem local("local");

//Detekcija i zapisivanje u datoteku/consolu
void detection(){
    FILE* File1 = freopen("/local/activity.txt","a",stdout);
    if(debounce.read_ms()>200){
        ledica=1;
        if(rtc.getTime(tmt)){
            pc.printf("%02d:%02d:%02d %s, %02d/%02d/%04d \r", tmt.hour, tmt.min, tmt.sec, rtc.weekdayToString(tmt.wday), tmt.mon, tmt.date, tmt.year);
            fprintf(File1,"%02d:%02d:%02d %s, %02d/%02d/%04d\n", tmt.hour, tmt.min, tmt.sec, rtc.weekdayToString(tmt.wday), tmt.mon, tmt.date, tmt.year);
        }
        ledica=0;
        fclose(File1);
        debounce.reset();
    }
}
 
//Glavna klasa - inicijalizacija
int main(){
    while(1){
    if(taster==1){
            led.disable(5);
            detector==0;
        }
    else if(taster==0){
        debounce.start();
        detector.rise(&detection);
        }
    }
}




