#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p19,p20,p21,p22,p23,p24);
DigitalOut Q_M1_pumpa(p5);
DigitalOut Q_M2_pumpa(p6);
DigitalIn kruska1(p7); //zastita od rada na suho
DigitalIn kruska2(p8); //razina uklopa prve pumpe
DigitalIn kruska3(p9); //razina uklopa druge pumpe
DigitalIn kruska4(p10); //razina alarm
DigitalOut Q_Alarm (p11);
InterruptIn Alarm_reset (p12);
DigitalIn reset_sati(p13);
Ticker Alarm_Led;
Timer titranje;

bool Alarm_full;
bool prva_radna (0);
bool druga_radna (0);
bool M1_prva_radna(0);
bool M1_druga_radna(0);
bool M2_prva_radna(0);
bool M2_druga_radna(0);


int M1_h (0);
int M2_h (0);

void upravljanje()
{
    kruska1.mode(PullUp);
    kruska2.mode(PullUp);
    kruska3.mode(PullUp);
    kruska4.mode(PullUp);
    {
        if (kruska2==1 or kruska3==1) {
            prva_radna = 1;
        }
        if (kruska3==1) {
            druga_radna = 1;
        }
        if (kruska2==0) {
            wait (1.0);
            prva_radna = 0;
            druga_radna = 0;
        }
        if (kruska1==0) {
            prva_radna = 0;
            druga_radna = 0;
        }
        if (kruska4==1) {
            Alarm_full = 1;
            wait(0.5);
        }
    }
    Q_M1_pumpa = ((prva_radna and M1_prva_radna) or (druga_radna and M1_druga_radna));
    Q_M2_pumpa = ((prva_radna and M2_prva_radna) or (druga_radna and M2_druga_radna));
}

void sati_rada ()
{
    if (Q_M1_pumpa==1) {
        M1_h = M1_h + 1;
        wait (2.0);
    }
    if (Q_M2_pumpa==1) {
        M2_h = M2_h + 1;
        wait (2.0);
    }
    if (reset_sati==1) {
        M1_h = 0;
        M2_h = 0;
    }
}

void izmjena_pumpi ()
{
    {
        if (M2_prva_radna==0 and (M1_h < (M2_h + 5))) {
            M1_prva_radna = 1;
            M2_druga_radna = 1;
        } else {
            M1_prva_radna = 0;
            M2_druga_radna = 0;
        }
    }
    {
        if (M1_prva_radna==0 and (M2_h < M1_h)) {
            M2_prva_radna = 1;
            M1_druga_radna = 1;
        } else {
            M2_prva_radna = 0;
            M1_druga_radna = 0;
        }
    }
}


void LCD_text ()
{
    if (kruska1==0&&kruska2==0&&kruska3==0&&kruska4==0) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Nivo suho");
        lcd.locate(0,1);
        lcd.printf("M1-%ih", M1_h);
        lcd.locate(8,1);
        lcd.printf("M2-%ih", M2_h);
        wait(0.5);
    }
    if (kruska1==1&&kruska2==0&&kruska3==0&&kruska4==0) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Nizak nivo");
        lcd.locate(0,1);
        lcd.printf("M1-%ih", M1_h);
        lcd.locate(8,1);
        lcd.printf("M2-%ih", M2_h);
        wait(0.5);
    }
    if (kruska1==1&&kruska2==1&&kruska3==0&&kruska4==0) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Srednji nivo");
        lcd.locate(0,1);
        lcd.printf("M1-%ih", M1_h);
        lcd.locate(8,1);
        lcd.printf("M2-%ih", M2_h);
        wait(0.5);
    }
    if (kruska1==1&&kruska2==1&&kruska3==1&&kruska4==0) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Visok nivo");
        lcd.locate(0,1);
        lcd.printf("M1-%ih", M1_h);
        lcd.locate(8,1);
        lcd.printf("M2-%ih", M2_h);
        wait(0.5);
    }
    if (kruska1==1&&kruska2==1&&kruska3==1&&kruska4==1) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Alarm-preljev");
        lcd.locate(0,1);
        lcd.printf("M1-%ih", M1_h);
        lcd.locate(8,1);
        lcd.printf("M2-%ih", M2_h);
        wait(0.5);
    }
}


void alarm_prepunjenost ()
{
    if (Alarm_full==1) {
        Q_Alarm = !Q_Alarm;
    }
    if (Alarm_full==0) {
        Q_Alarm = 0;
    }
}

void alarm_led_reset ()
{
    if (titranje.read_ms()>200)
        Alarm_full = 0;
    titranje.reset();
}

int main()
{
    while(1) {
        upravljanje();
        sati_rada ();
        izmjena_pumpi ();
        LCD_text ();

        Alarm_Led.attach(&alarm_prepunjenost, 0.5);

        titranje.start();
        Alarm_reset.rise(&alarm_led_reset);
    }
}