#include "mbed.h"
#include "MPU.h"
#include "HCSR04.h"
#include "TextLCD.h"

/*
class LED_interrupt
{

public:
    LED_interrupt(PinName tipkalo_pin, PinName led_pin) : _tipkalo(tipkalo_pin), _stanje(led_pin)
    {
        _tipkalo.fall(callback(this, &LED_interrupt::promjena));
        off();
    };

    void off(void)
    {
        _stanje = 1;
    };

    void promjena(void)
    {
        _stanje = !_stanje;
    };

private:
    DigitalOut _stanje;
    InterruptIn _tipkalo;

};
*/
DigitalOut led(LED1);
Timer debounce;

void flip()
{
    if (debounce.read_ms()>200)
        led = !led;
    debounce.reset();
}

Serial pc(USBTX,USBRX);
Senzor mpu(p9,p10);                                             // žiroskop (Sda, Scl)
HCSR04 sensor(p7,p8);                                           // ultrazvučni senzor (trig, echo)
TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2);    // display (rs, e, d4-d7)
InterruptIn _tipkalo(p12);

void calc()
{
    sensor.startMeasurement();
}

int main()
{
    float angle[3] = {0, 0, 0};
    float temp;
    float sampleTime = 0.5;
    Ticker ticker;
    float distance;

    pc.printf("\nPocnimo\n");

    sensor.setRanges(2, 400);
    pc.printf("Minimum sensor range = %g cm\n\rMaximum sensor range = %g cm\n\r", sensor.getMinRange(), sensor.getMaxRange());
    ticker.attach(&calc, sampleTime);

    //LED_interrupt(p12,LED1);
    debounce.start();
    _tipkalo.rise(&flip);

    while(true) {

        mpu.finalAngle(angle);
        temp=mpu.getTemp();
        distance = sensor.getDistance_mm();

        //lcd.cls();
        //lcd.locate(0,1);
        pc.printf("\n\rpitch: %.4f", angle[0]);

        //lcd.locate(0,0);
        pc.printf("\n\rroll: %.4f", angle[1]);

        pc.printf("\n\rTemp: %.4f",temp);
        pc.printf("\n\rDistance: %f mm\r", distance);

        wait(1);

    }
}