#ifndef MBED_MPU_H
#define MBED_MPU_H

#include "mbed.h"

#define ADDRESS (0x68<<1)//iako je adresa 7 bitna mora biti shiftana za jedno mjesto u lijevo
#define WHO_AM_I_REG 0x75// vraća adresu 
#define PWR_MGMT_1_REG 0x6B// podešavanje power mode i izvora sata
#define CONFIG_REG 0x1A//konfiguracija
#define GYRO_CONFIG_REG 0x1B//konfiguracija žiroskopa
#define ACCELERO_CONFIG_REG 0x1C//konfiguracija akcelerometra
#define GYRO_XOUT_H_REG 0x43
#define ACCEL_XOUT_H_REG 0x3B
#define TEMP_H_REG 0x41

class Senzor{
    public:
    Senzor(PinName Sda, PinName Scl);
    char testConnection ();
    void setBW (char command);
    void setPowerManagement (char command);
    void GYRO_CONFIG(char command);
    void ACCEL_CONFIG(char command);
    void getAccel(float *accel);
    void getGyro(float *gyro);
    void getAccAngle(float *angle);
    void getOffset(float *accOffset, float *gyroOffset, int sample);
    void finalAngle (float *angle);
    float getTemp();
    
    private:
    I2C mpu;
    
    };
#endif