//TODO: dodati sd card logger
//TODO: dodati conversion for sensors
//TODO: Serial Read from LabView on start
//TODO: PWM output 

#include "mbed.h"
#include "stdio.h"
#include "string"

#define SAMPLE_RATE 0.01
Serial pc(USBTX, USBRX); // tx, rx

Timer timer;
AnalogIn a_input[] = {A0,A1,A2,A3,A4};
const int numberOfInputs=5;
float analog_values[numberOfInputs];

char buffer[100];
char temp[30];
void read_inputs();
void convert_inputs();
void send_results();

void flushSerialBuffer(void) { char char1 = 0; while (pc.readable()) { char1 = pc.getc(); } return; }

int main() {
    timer.start();
    flushSerialBuffer();
    while(1){
        if (timer.read() > SAMPLE_RATE) {
        read_inputs();
        convert_inputs();         
        send_results();
        timer.reset();
                    }       
             }
 }
void read_inputs(){
    for (int i=0;i<numberOfInputs;i++){
        analog_values[i]= a_input[i].read()*3.3;   //convert to voltage
        }
    }
void convert_inputs(){
     for (int i=0;i<numberOfInputs;i++){
         sprintf(temp,"%.3f",analog_values[i]); //convert float to string
         strcat(temp,"#"); //add delimiter
         strcat(buffer,temp);  //concatenate buffer and new value
        }
    strcat(buffer,"?"); //end char
    }
void send_results(){
    pc.printf(buffer);   //serial send buffer
    sprintf(buffer,"$"); //start char
    }