#include "mbed.h"
#include "mikrovalna.h"
#include "TextLCD.h"


PwmOut PWM1(p25); // zvučnik
InterruptIn start(p12), vrijeme_time(p11), power(p10);                  //interrupti preko tipkala
DigitalOut led_1(LED1), led_2(LED2), led_3(LED3), led_4(LED4);          //led-ice na mbed-u
DigitalOut bled_1(p5), bled_2(p6), bled_3(p7), bled_4(p8);              //plave ledice
Timer debounce_start, debounce_vrijeme_time, debounce_power, brojac;    //timeri za debounce tipkala i brojač za proteklo vrijeme


Mikrovalna Mikrovalna(p14, p15, p16);                                   //poziv klase


int i=0;                                                                //globalna varijalbla
int j=0;                                                                //globalna varijalbla
int t=0;                                                                //globalna varijalbla
int t1=0;                                                               //globalna varijalbla


void fsnaga(){                                                          //funkcija za aktivaciju vanjskih lampica na pritisak tipkala
    if(debounce_power.read_ms()>200){
        if(i<4){
            i++;
        }else{
            i=0;
        }
        debounce_power.reset();                                         // reset debounce timera
    
    }
        if (i==1){                                                      // paljenje vanjskih lampica
            bled_1=1;
            bled_2=0;            
            bled_3=0;
            bled_4=0;
            
        } else if(i==2){                                                // paljenje vanjskih lampica
            bled_1=1;
            bled_2=1;
            bled_3=0;
            bled_4=0;
            
        } else if(i==3){                                                // paljenje vanjskih lampica
            bled_1=1;
            bled_2=1;
            bled_3=1;
            bled_4=0;
            
        } else if(i==4){                                                // paljenje vanjskih lampica
            bled_1=1;
            bled_2=1;
            bled_3=1;
            bled_4=1;
            
        } else if(i==0){                                                // paljenje vanjskih lampica
            bled_1=0;
            bled_2=0;
            bled_3=0;
            bled_4=0;
        }              
}


void fvrijeme(){                                                        //funkcija za dodavanje vremenskog intervala od 10 sekundi u ukupnu sumu - pomoću tipkala
    if(debounce_vrijeme_time.read_ms()>200){
       if(t<120){
        t=t+10;
        }else{
            t=0;
        }
    debounce_vrijeme_time.reset();                                      // reset debounce timera
    }
}


void fstart(){                                                          //funkcija za pokretanje/gašenje mikrovalne pećnice
    if(debounce_start.read_ms()>200){
       if(j==0 && t>0 && i>0){
            j=1;
            brojac.reset();
        }else if(j==1){
            j=0;
        }
    debounce_vrijeme_time.reset();                                      // reset debounce timera
    }
    if(j==0 && t>0 && i>0){                                             // kada se izvršava program i prekine se (pauzira) izvršavanje onda se zapamti vrijdnost brojača i on se resetira
        t=t - brojac.read();                                            // vrijednost se oduzima od ukupnog vremena t
        brojac.reset();                                                 // reset timera brojača
    }


}

 
int main() {                                                            // glavna funkcija program

    power.rise(&fsnaga);                                                //poziv funkcije za paljenje vaskih lampica pritiskom na tipku, palu se više lampica ako je potrebna veća snaga
    vrijeme_time.rise(&fvrijeme);                                       //poziv funkcije povećvanje vremena aktivnosti mikrovalne
    start.rise(&fstart);                                                //poziv funkcije za paljenje/gašenje mikrovalne pećnice
    
    debounce_power.start();                                             //start timera za debounce
    debounce_vrijeme_time.start();                                      //start timera za debounce
    debounce_start.start();                                             //start timera za debounce
    
    t1=0;                                                               //resetiranje varijable
    i=0;                                                                //resetiranje varijable
    j=0;                                                                //resetiranje varijable
    t=0;                                                                //resetiranje varijable
    
    while(1){                                                           //beskonačna petlja
        if(j==0 || i==0 || t==0){                                       //'idle' tj. mikrovalna pečnica ne radi i spremna je prihvatiti nove vrijednosti
            t1=t;                                                       //korištenje pomoćne varijable
            PWM1.period(0.0);                                           //reset zvučnika
            PWM1=0.5;
            wait(0);
            if(i==0){                                                   //reset lampica za indikaciju željene snage
                bled_1=0;
                bled_2=0;
                bled_3=0;
                bled_4=0;
                }
            led_1=!led_1;                                               //lampice na mbed-u trepere u trakanju od 1 sekunde
            led_2=!led_2;
            led_3=!led_3;
            led_4=!led_4;
            wait(1);
                    
        }else if (j==1 && i>0 && t>0){                                  //mikrovalna je upaljena i izabrani su vrijeme i snaga
            led_1=1;                                                    //lampice na mbed-u konstantno svijetle
            led_2=1;
            led_3=1;
            led_4=1;
            
            PWM1.period(0.001);                                         //zvučnik je aktiviran
            PWM1=0.5;
            wait(0.5);
            brojac.start();                                             //akrivacija timera brojača
            if(brojac.read()>t1){                                       //uvijet za završetak tj. za resetiranje 
                t=0;                                                    //resetiranje vrijednosti globalnih varijabi
                j=0;                                                    //resetiranje vrijednosti globalnih varijabi
                i=0;                                                    //resetiranje vrijednosti globalnih varijabi
                t1=0;                                                   //resetiranje vrijednosti globalnih varijabi
                brojac.reset();                                         //resetiranje vrijednosti timera brojač
            }
        } 
    }
}