#include "mbed.h"
#include "Adafruit_SSD1306.h" 

#define SSD_I2C_ADDRESS     0x78 //definiranje adrese za OLED
#define mp0 2200 //pozicija motora 0
#define mp1 1100 //pozicija motora 1
#define mp2 300  //pozicija motora 2

/** Inicijalizacija I2C **/
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(400000);
        start();
    };
};
 
 
I2CPreInit gI2C(p9,p10); //sda,scl
Adafruit_SSD1306_I2c oled(gI2C,p27);//dodatni scl potreban za library

/*** Bluetooth ***/

Serial bt(p13, p14); // tx, rx

/*** Serial PC ****/

Serial pc(USBTX,USBRX); // tx, rx


/*** Servo *****/

PwmOut servoMost(p25); // Guranje proizvoda
PwmOut servoTobogan(p26); // Sortiranje proizvoda

/*** Senzor boje ***/

DigitalOut s0(p24);
DigitalOut s1(p23);
DigitalOut s2(p22);
DigitalOut s3(p21);
DigitalOut sOE(p30);

DigitalIn sout(p29);

/*** Timer ***/

Timer tCrveno,tPlavo,tZeleno;

/*** Ticker ***/

Ticker ticker;

/*** Reader (Bluetooth) ***/

void reader (void);
int btPodatak=0;
int c, z, p, s, u; // Broj komada
char stasto='0'; // Uvjet da proces nije uključen
char boja;

void reader() {
        
        /*** Čitanje stanja na Bluetooth-u ***/
        if(bt.readable()) {
            btPodatak = bt.getc();
            }   
        
        /*** Uvjet je li pritisnut START/STOP ***/ 
        if(btPodatak=='s' || btPodatak=='p'){
            stasto=btPodatak;
            }
        
        /*** Uvjet za prikaz na OLED-u ***/
        if(btPodatak>='0' && btPodatak<='5'){
            boja=btPodatak;
            }
        
        switch(boja){
            
            case '0': //Pritisnuta tipka "Svi"
            oled.clearDisplay();
            oled.setTextCursor(0,0);
            oled.printf("Crveno: %u\n\r%",c);
            oled.setTextCursor(0,11);
            oled.printf("Plavo: %u\n\r",p);
            oled.setTextCursor(0,22);
            oled.printf("Zeleno: %u\n\r",z);
            oled.setTextCursor(0,33);
            oled.printf("Skart: %u\n\r%",s);
            oled.drawLine(0x0,50,0xF0,50,1);
            oled.setTextCursor(0, 53);
            oled.printf("Ukupno: %u\n\r",u);
            oled.display();    
            break;
            
            case '1': //Pritisnuta tipka "Crveno"
            oled.clearDisplay();
            oled.setTextCursor(0,0);
            oled.printf("Crveno: %u\n\r%",c);
            oled.drawLine(0x0,50,0xF0,50,1);
            oled.setTextCursor(0, 53);
            oled.printf("Ukupno: %u\n\r",u);
            oled.display();    
            break;
            
            case '2': //Pritisnuta tipka "Plavo"
            oled.clearDisplay();
            oled.setTextCursor(0,0);
            oled.printf("Plavo: %u\n\r%",p);
            oled.drawLine(0x0,50,0xF0,50,1);
            oled.setTextCursor(0, 53);
            oled.printf("Ukupno: %u\n\r",u);
            oled.display();    
            break;
            
            case '3': //Pritisnuta tipka "Zeleno"
            oled.clearDisplay();
            oled.setTextCursor(0,0);
            oled.printf("Zeleno: %u\n\r%",z);
            oled.drawLine(0x0,50,0xF0,50,1);
            oled.setTextCursor(0, 53);
            oled.printf("Ukupno: %u\n\r",u);
            oled.display();    
            break;
            
            case '4': //Pritisnuta tipka "Skart"
            oled.clearDisplay();
            oled.setTextCursor(0,0);
            oled.printf("Skart: %u\n\r%",s);
            oled.drawLine(0x0,50,0xF0,50,1);
            oled.setTextCursor(0, 53);
            oled.printf("Ukupno: %u\n\r",u);
            oled.display();    
            break;
            
            case '5': //Pritisnuta tipka "Prazno"
            oled.clearDisplay();
            oled.display();
            break;
            }
}

int main()
{
    pc.baud(9600);

    /***Senzor Boje****/
    /* Skaliranje frekvencije na 20% */
    s0=1;
    s1=0;
    
    /** Kada je sOE (enable bit) u LOW (0) stanju, senzor očitava **/
    sOE=1;

    int crveno=0;
    int plavo=0;
    int zeleno=0;

    int avrCrveno=0;
    int avrPlavo=0;
    int avrZeleno=0;

    int zbCrveno=0;
    int zbPlavo=0;
    int zbZeleno=0;

    int count=0;
    

    /*** Servo***/

    servoMost.period_ms(20);
    servoMost.pulsewidth_us(1100);

    wait(1);

    servoTobogan.period_ms(20);
    servoTobogan.pulsewidth_us(1100);

    wait(1);

    ticker.attach(&reader,0.1);
    
    while(1) {            
        
            if(stasto=='s'){ //START

                pc.printf("start\n\r");
                
                servoMost.pulsewidth_us(mp0); // Pozicija 0 (Preuzimanje proizvoda)
                
                wait(1);

                servoMost.pulsewidth_us(mp1); // Pozicija 1 (Postavljanje ispod senzora)
                
                sOE=0; // Palimo senzor

                for(int j=0; j<10000; j++) {
                    // provjera crvene boje
                    s2=0;
                    s3=0;

                    tCrveno.start();
                    while(sout == 1) {
                        crveno=tCrveno.read_us();
                    }


                    tCrveno.stop();
                    tCrveno.reset();

                    zbCrveno=zbCrveno+crveno;

                    // provjera plave boje
                    s2=0;
                    s3=1;

                    tPlavo.start();
                    while(sout == 1) {
                        plavo=tPlavo.read_us();
                    }


                    tPlavo.stop();
                    tPlavo.reset();

                    zbPlavo=zbPlavo+plavo;

                    // provjera zelene boje
                    s2=1;
                    s3=1;

                    tZeleno.start();
                    while(sout == 1) {
                        zeleno=tZeleno.read_us();
                    }


                    tZeleno.stop();
                    tZeleno.reset();


                    zbZeleno=zbZeleno+zeleno;


                    //artitmetička sredina
                    count++;
                    avrCrveno=zbCrveno/count;
                    avrPlavo=zbPlavo/count;
                    avrZeleno=zbZeleno/count;
                }
                
                sOE=1; // Gasimo senzor


                pc.printf("C=%d P=%d Z=%d\n\r",avrCrveno,avrPlavo,avrZeleno);

                if(avrCrveno>200 && avrZeleno<150) {

                    servoTobogan.pulsewidth_us(300);
                    wait(1);
                    servoMost.pulsewidth_us(mp2); //pozicija 2
                    wait(1);
                    
                    z++;

                    pc.printf("Zeleno\n\r");

                } else if(avrCrveno<100 && avrZeleno>200) {

                    servoTobogan.pulsewidth_us(800);
                    wait(1);
                    servoMost.pulsewidth_us(mp2);
                    wait(1);
                    
                    c++;

                    pc.printf("Crveno\n\r");
                    

                } else if(avrPlavo <100 && avrCrveno >100) {

                    servoTobogan.pulsewidth_us(1500);
                    wait(1);
                    servoMost.pulsewidth_us(mp2);
                    wait(1);
                    
                    p++;

                    pc.printf("Plavo\n\r");

                } else {


                    servoTobogan.pulsewidth_us(2000);
                    wait(1);
                    servoMost.pulsewidth_us(mp2);
                    wait(1);
                    
                    s++;

                    pc.printf("Skart\n\r");
                }
                
                u=c+p+z+s;

                count=0;
                zbCrveno=0;
                zbPlavo=0;
                zbZeleno=0;
                avrCrveno=0;
                avrPlavo=0;
                avrZeleno=0;

                servoMost.pulsewidth_us(mp0);

            }
        }
    }
}