#include "mbed.h"

InterruptIn optic(p18);
Serial nextion(p28, p27);
Ticker sendData;

Timer t;
float T = 0;
uint16_t rpm = 0;
bool flag = false;

void prolaz(){   
    T = t.read();
    t.reset();
    flag = true;
}

void data(){   
    if (t.read() < 1.0 && flag)  
        rpm = 30.0/T; // rpm = 60 * f = 60 * 1/T * 1/2 = 30/T
    else rpm = 0;
    nextion.printf("t1.txt=\"%d rpm\"%c%c%c", rpm, 255, 255, 255); //t1.txt="tekst" 0xFF 0xFF 0xFF
    nextion.printf("add 5,0,%d%c%c%c", rpm/100, 255, 255, 255); //add <waveform>,<channel>,<value> 0xFF 0xFF 0xFF
}

int main(){
    t.start();
    optic.rise(&prolaz);
    sendData.attach(&data, 1.0);
    while(1) {
        wait(1.0);
    }
}