// Primjer postavljanja mbed Ticker-a na nizi prioritet
// Nested Vectored Interrupt Controller (NVIC) 
#include "mbed.h"
// Varijabla za brojanje rastucih bridova PwmOut objekta
volatile int counter = 0; 
// Callback funkcija koju poziva InterruptIn objekt
void timing_critical() { 
    counter++;
}

// Callback funkcija koju poziva Ticker objekt
void long_event() { 
    wait_ms(50);
}

PwmOut out(p25);
InterruptIn in(p26);
Ticker tick;

int main() {
    // Generiranje PWM signala
    out.period_ms(10);
    out.pulsewidth_ms(5);
    // Poziv callback funkcije void timing_critical(); na svaki rastuci brid od InterruptIn pina
    in.rise(&timing_critical);
 
    // Uzimanje 5 sample-ova svakih 1 sec
    printf("1) InterruptIn only...\n");    
    for(int i=0; i<5; i++) {
        counter = 0;
        wait(1);
        printf("counts/sec = %d\n", counter);
    }
 
    // Poziv callback funkcije void long_event(); od strane Ticker objekta u periodu od 0.1 sec
    tick.attach(&long_event, 0.1);    
    
    // Uzimanje 5 sample-ova svakih 1 sec sa ukljucenim Ticker objektom bez postavljanja prioritera
    printf("2) InterruptIn plus long running occasional ticker event...\n");    
    for(int i=0; i<5; i++) {
        counter = 0;
        wait(1);
        printf("count/sec = %d\n", counter);
    }
    
    // Uzimanje 5 sample-ova svakih 1 sec sa ukljucenim Ticker objektom sa postavljenim prioritetom
    printf("3) InterruptIn plus long running occasional ticker event at lower priority...\n"); 
    // Postavi mbed ticker na najnizi prioritet   
    NVIC_SetPriority(TIMER3_IRQn, 255); 
    for(int i=0; i<5; i++) {
        counter = 0;
        wait(1);
        printf("counter = %d\n", counter);
    }
}