#include "mbed.h"
#include "Temperatura.h"
#include "C12832.h"

Temperatura::Temperatura(PinName tipkaloPin, PinName senzorPin, PinName zvucnikPin) : tipkalo(tipkaloPin), senzor(senzorPin), zvucnik(zvucnikPin), lcd(p5, p7, p6, p8, p11) {
    debounce.start();
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Mjerenje se moze pokrenuti...");
    mjerenjePokrenuto = ukljucenZvucnik = false;
    zvucnik.period(1.0f / 500);
    tipkalo.rise(this, &Temperatura::startStopMjerenja);
}

void Temperatura::startStopMjerenja() {
    if(debounce.read_ms() > 20) {
        if(!mjerenjePokrenuto) {
            mjerenjePokrenuto = true;
            ticker.attach(this, &Temperatura::mjeriIPrikazi, 0.5);
        } else {
            mjerenjePokrenuto = false;
            ticker.detach();
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Mjerenje se moze pokrenuti...");
        }
        debounce.reset();
    }
}


void Temperatura::mjeriIPrikazi() {
    float temperatura = -25 + (75 - (-25)) / ((3-0.5f)/3.3f) * (senzor.read() - (0.5f/3.3f));
    lcd.cls();
    lcd.locate(0,3);
    if (temperatura >= -25 && temperatura <= 75) {
        lcd.printf("Temperatura: %5.1f °C", temperatura);
    } else {
        lcd.printf("Temperatura izvan mjernog opsega!");
        if (!ukljucenZvucnik) {
            zvucnik = 0.5;
            ukljucenZvucnik = true;
            timeout.attach(this, &Temperatura::iskljuciZvucnik, 0.5);
        }
    }
}
void Temperatura::iskljuciZvucnik() {
    zvucnik = 0;
    ukljucenZvucnik = false;
    /* tko se jos zeli igrati s trajanjem pauze izmedju zvucnih signala
     * moze dodati jos jedan timeout objekt vezan na bool varijablu
     * ukljucenZvucnik 
     */
}