#ifndef TEMPERATURA_H
#define TEMPERATURA_H

#include "mbed.h"
#include "C12832.h"

/** Rješenje ispita PURS_ZI_010 */
class Temperatura {
public:
    /** Konstruktor prima pinove tipkala, senzora i zvučnika.
     * @param tipkaloPin Pin tipkala.
     * @param senzorPin Pin analognog temperaturnog senzora.
     * @param zvucnikPin Pin na koji je spojen zvučnik.
     */
    Temperatura(PinName tipkaloPin, PinName senzorPin, PinName zvucnikPin);
private:
    C12832 lcd;
    InterruptIn tipkalo;
    AnalogIn senzor;
    PwmOut zvucnik;
    Timer debounce;
    bool mjerenjePokrenuto, ukljucenZvucnik;
    Ticker ticker;
    Timeout timeout;
    void startStopMjerenja();
    void mjeriIPrikazi();
    void iskljuciZvucnik();
};

#endif