#include "mbed.h"
#include "C12832.h"
#include "TempSenzor.h"

TempSenzor::TempSenzor (PinName prviPin, PinName drugiPin, PinName tipkaPin): senzor1(prviPin), senzor2(drugiPin), tipka(tipkaPin), lcd(p5, p7, p6, p8, p11){
    odabraniC=true;
    ispis.attach(this, &TempSenzor::ispisi, 0.5);
    tipka.rise(this, &TempSenzor::ocitajVrijednost);
    debounceTipka.start();
   
   
    }
    
        
void TempSenzor::ocitajVrijednost(){
    if (debounceTipka.read_ms()>20){
        if(odabraniC==true){
        odabraniC=false;
        }
    else{
        odabraniC=true;
        }
        
debounceTipka.reset();
    }
    
    }
    
    
    
    
void TempSenzor::ispisi(){
    if(odabraniC==true){
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Senzor 1: %f C\n",senzor1*330);
        lcd.printf("Senzor 2: %f C\n", senzor2*330);
        prosjek1= ((senzor1*330)+(senzor2*330))/2;
        lcd.printf("Prosjek: %f C\n", prosjek1);
        }
    else {
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Senzor 1: %f K\n",(senzor1*330)+273.15);
        lcd.printf("Senzor 2: %f K\n", (senzor2*330)+273.15);
        prosjek2= ((senzor1*330)+273.15)+((senzor2*330)+273.15)/2;
        lcd.printf("Prosjek: %f K\n", prosjek2);
        
        }
    
    }