#include "mbed.h"
#include "Sviraj.h"

Sviraj::Sviraj(PinName pinIzbora, PinName pinZvucnika) : izbor(pinIzbora), zvucnik(pinZvucnika) {
    izbor.rise(this, &Sviraj::izborTona);
    debounce.start();
    zvucnik = 0;
    odabraniTon = 4;
    frekvencija = 1; // u kHz
}

void Sviraj::izborTona() {
    if (debounce.read_ms() > 20) {
        odabraniTon = ++odabraniTon % 5;
        for (int i=0; i < odabraniTon; i++)
            frekvencija *= 2;
        zvucnik.period(1/(frekvencija*1000));
        frekvencija = 1;
        zvucnik = 0.5;
        vrijemeTona.attach(this, &Sviraj::iskljuciZvucnik, 5);
        debounce.reset();
    }
}

void Sviraj::iskljuciZvucnik() {
    zvucnik = 0;
}